@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The essential information related to the peer's ASN.
 * @property errorMessage The error message for the validation state
 * @property id The ID of the resource.
 * @property name The name of the resource.
 * @property peerAsn The Autonomous System Number (ASN) of the peer.
 * @property peerContactDetail The contact details of the peer.
 * @property peerName The name of the peer.
 * @property type The type of the resource.
 * @property validationState The validation state of the ASN associated with the peer.
 */
public data class GetPeerAsnResult(
    public val errorMessage: String,
    public val id: String,
    public val name: String,
    public val peerAsn: Int? = null,
    public val peerContactDetail: List<ContactDetailResponse>? = null,
    public val peerName: String? = null,
    public val type: String,
    public val validationState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.peering.outputs.GetPeerAsnResult): GetPeerAsnResult = GetPeerAsnResult(
            errorMessage = javaType.errorMessage(),
            id = javaType.id(),
            name = javaType.name(),
            peerAsn = javaType.peerAsn().map({ args0 -> args0 }).orElse(null),
            peerContactDetail = javaType.peerContactDetail().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.peering.kotlin.outputs.ContactDetailResponse.Companion.toKotlin(args0)
                })
            }),
            peerName = javaType.peerName().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            validationState = javaType.validationState(),
        )
    }
}
