@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The customer's prefix that is registered by the peering service provider.
 * @property errorMessage The error message associated with the validation state, if any.
 * @property id The ID of the resource.
 * @property name The name of the resource.
 * @property peeringServicePrefixKey The peering service prefix key that is to be shared with the customer.
 * @property prefix The customer's prefix from which traffic originates.
 * @property prefixValidationState The prefix validation state.
 * @property provisioningState The provisioning state of the resource.
 * @property type The type of the resource.
 */
public data class GetRegisteredPrefixResult(
    public val errorMessage: String,
    public val id: String,
    public val name: String,
    public val peeringServicePrefixKey: String,
    public val prefix: String? = null,
    public val prefixValidationState: String,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.peering.outputs.GetRegisteredPrefixResult): GetRegisteredPrefixResult = GetRegisteredPrefixResult(
            errorMessage = javaType.errorMessage(),
            id = javaType.id(),
            name = javaType.name(),
            peeringServicePrefixKey = javaType.peeringServicePrefixKey(),
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
            prefixValidationState = javaType.prefixValidationState(),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
        )
    }
}
