@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The properties that define a direct peering.
 * @property connections The set of connections that constitute a direct peering.
 * @property directPeeringType The type of direct peering.
 * @property peerAsn The reference of the peer ASN.
 * @property useForPeeringService The flag that indicates whether or not the peering is used for peering service.
 */
public data class PeeringPropertiesDirectResponse(
    public val connections: List<DirectConnectionResponse>? = null,
    public val directPeeringType: String? = null,
    public val peerAsn: SubResourceResponse? = null,
    public val useForPeeringService: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.peering.outputs.PeeringPropertiesDirectResponse): PeeringPropertiesDirectResponse = PeeringPropertiesDirectResponse(
            connections = javaType.connections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.peering.kotlin.outputs.DirectConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            directPeeringType = javaType.directPeeringType().map({ args0 -> args0 }).orElse(null),
            peerAsn = javaType.peerAsn().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.peering.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            useForPeeringService = javaType.useForPeeringService(),
        )
    }
}
