@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * The properties that define an exchange peering.
 * @property connections The set of connections that constitute an exchange peering.
 * @property peerAsn The reference of the peer ASN.
 */
public data class PeeringPropertiesExchangeResponse(
    public val connections: List<ExchangeConnectionResponse>? = null,
    public val peerAsn: SubResourceResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.peering.outputs.PeeringPropertiesExchangeResponse): PeeringPropertiesExchangeResponse = PeeringPropertiesExchangeResponse(
            connections = javaType.connections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.peering.kotlin.outputs.ExchangeConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            peerAsn = javaType.peerAsn().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.peering.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
