@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.policyinsights.kotlin

import com.pulumi.azurenative.policyinsights.AttestationAtResourceGroupArgs.builder
import com.pulumi.azurenative.policyinsights.kotlin.enums.ComplianceState
import com.pulumi.azurenative.policyinsights.kotlin.inputs.AttestationEvidenceArgs
import com.pulumi.azurenative.policyinsights.kotlin.inputs.AttestationEvidenceArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * An attestation resource.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * ## Example Usage
 * ### Create attestation at resource group scope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var attestationAtResourceGroup = new AzureNative.PolicyInsights.AttestationAtResourceGroup("attestationAtResourceGroup", new()
 *     {
 *         AssessmentDate = "2021-06-10T00:00:00Z",
 *         AttestationName = "790996e6-9871-4b1f-9cd9-ec42cd6ced1e",
 *         Comments = "This subscription has passed a security audit.",
 *         ComplianceState = AzureNative.PolicyInsights.ComplianceState.Compliant,
 *         Evidence = new[]
 *         {
 *             new AzureNative.PolicyInsights.Inputs.AttestationEvidenceArgs
 *             {
 *                 Description = "The results of the security audit.",
 *                 SourceUri = "https://gist.github.com/contoso/9573e238762c60166c090ae16b814011",
 *             },
 *         },
 *         ExpiresOn = "2021-06-15T00:00:00Z",
 *         Metadata = new Dictionary<string, object?>
 *         {
 *             ["departmentId"] = "NYC-MARKETING-1",
 *         },
 *         Owner = "55a32e28-3aa5-4eea-9b5a-4cd85153b966",
 *         PolicyAssignmentId = "/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5",
 *         PolicyDefinitionReferenceId = "0b158b46-ff42-4799-8e39-08a5c23b4551",
 *         ResourceGroupName = "myRg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/policyinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := policyinsights.NewAttestationAtResourceGroup(ctx, "attestationAtResourceGroup", &policyinsights.AttestationAtResourceGroupArgs{
 * 			AssessmentDate:  pulumi.String("2021-06-10T00:00:00Z"),
 * 			AttestationName: pulumi.String("790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
 * 			Comments:        pulumi.String("This subscription has passed a security audit."),
 * 			ComplianceState: pulumi.String(policyinsights.ComplianceStateCompliant),
 * 			Evidence: policyinsights.AttestationEvidenceArray{
 * 				&policyinsights.AttestationEvidenceArgs{
 * 					Description: pulumi.String("The results of the security audit."),
 * 					SourceUri:   pulumi.String("https://gist.github.com/contoso/9573e238762c60166c090ae16b814011"),
 * 				},
 * 			},
 * 			ExpiresOn: pulumi.String("2021-06-15T00:00:00Z"),
 * 			Metadata: pulumi.Any(map[string]interface{}{
 * 				"departmentId": "NYC-MARKETING-1",
 * 			}),
 * 			Owner:                       pulumi.String("55a32e28-3aa5-4eea-9b5a-4cd85153b966"),
 * 			PolicyAssignmentId:          pulumi.String("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
 * 			PolicyDefinitionReferenceId: pulumi.String("0b158b46-ff42-4799-8e39-08a5c23b4551"),
 * 			ResourceGroupName:           pulumi.String("myRg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.policyinsights.AttestationAtResourceGroup;
 * import com.pulumi.azurenative.policyinsights.AttestationAtResourceGroupArgs;
 * import com.pulumi.azurenative.policyinsights.inputs.AttestationEvidenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var attestationAtResourceGroup = new AttestationAtResourceGroup("attestationAtResourceGroup", AttestationAtResourceGroupArgs.builder()
 *             .assessmentDate("2021-06-10T00:00:00Z")
 *             .attestationName("790996e6-9871-4b1f-9cd9-ec42cd6ced1e")
 *             .comments("This subscription has passed a security audit.")
 *             .complianceState("Compliant")
 *             .evidence(AttestationEvidenceArgs.builder()
 *                 .description("The results of the security audit.")
 *                 .sourceUri("https://gist.github.com/contoso/9573e238762c60166c090ae16b814011")
 *                 .build())
 *             .expiresOn("2021-06-15T00:00:00Z")
 *             .metadata(Map.of("departmentId", "NYC-MARKETING-1"))
 *             .owner("55a32e28-3aa5-4eea-9b5a-4cd85153b966")
 *             .policyAssignmentId("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5")
 *             .policyDefinitionReferenceId("0b158b46-ff42-4799-8e39-08a5c23b4551")
 *             .resourceGroupName("myRg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:policyinsights:AttestationAtResourceGroup 790996e6-9871-4b1f-9cd9-ec42cd6ced1e /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/attestations/{attestationName}
 * ```
 * @property assessmentDate The time the evidence was assessed
 * @property attestationName The name of the attestation.
 * @property comments Comments describing why this attestation was created.
 * @property complianceState The compliance state that should be set on the resource.
 * @property evidence The evidence supporting the compliance state set in this attestation.
 * @property expiresOn The time the compliance state should expire.
 * @property metadata Additional metadata for this attestation
 * @property owner The person responsible for setting the state of the resource. This value is typically an Azure Active Directory object ID.
 * @property policyAssignmentId The resource ID of the policy assignment that the attestation is setting the state for.
 * @property policyDefinitionReferenceId The policy definition reference ID from a policy set definition that the attestation is setting the state for. If the policy assignment assigns a policy set definition the attestation can choose a definition within the set definition with this property or omit this and set the state for the entire set definition.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class AttestationAtResourceGroupArgs(
    public val assessmentDate: Output<String>? = null,
    public val attestationName: Output<String>? = null,
    public val comments: Output<String>? = null,
    public val complianceState: Output<Either<String, ComplianceState>>? = null,
    public val evidence: Output<List<AttestationEvidenceArgs>>? = null,
    public val expiresOn: Output<String>? = null,
    public val metadata: Output<Any>? = null,
    public val owner: Output<String>? = null,
    public val policyAssignmentId: Output<String>? = null,
    public val policyDefinitionReferenceId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.policyinsights.AttestationAtResourceGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.policyinsights.AttestationAtResourceGroupArgs =
        com.pulumi.azurenative.policyinsights.AttestationAtResourceGroupArgs.builder()
            .assessmentDate(assessmentDate?.applyValue({ args0 -> args0 }))
            .attestationName(attestationName?.applyValue({ args0 -> args0 }))
            .comments(comments?.applyValue({ args0 -> args0 }))
            .complianceState(
                complianceState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .evidence(
                evidence?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .expiresOn(expiresOn?.applyValue({ args0 -> args0 }))
            .metadata(metadata?.applyValue({ args0 -> args0 }))
            .owner(owner?.applyValue({ args0 -> args0 }))
            .policyAssignmentId(policyAssignmentId?.applyValue({ args0 -> args0 }))
            .policyDefinitionReferenceId(policyDefinitionReferenceId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AttestationAtResourceGroupArgs].
 */
@PulumiTagMarker
public class AttestationAtResourceGroupArgsBuilder internal constructor() {
    private var assessmentDate: Output<String>? = null

    private var attestationName: Output<String>? = null

    private var comments: Output<String>? = null

    private var complianceState: Output<Either<String, ComplianceState>>? = null

    private var evidence: Output<List<AttestationEvidenceArgs>>? = null

    private var expiresOn: Output<String>? = null

    private var metadata: Output<Any>? = null

    private var owner: Output<String>? = null

    private var policyAssignmentId: Output<String>? = null

    private var policyDefinitionReferenceId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The time the evidence was assessed
     */
    @JvmName("bllffhllxgtxbjiu")
    public suspend fun assessmentDate(`value`: Output<String>) {
        this.assessmentDate = value
    }

    /**
     * @param value The name of the attestation.
     */
    @JvmName("nlpmfuqaaauoiwwn")
    public suspend fun attestationName(`value`: Output<String>) {
        this.attestationName = value
    }

    /**
     * @param value Comments describing why this attestation was created.
     */
    @JvmName("vydrfpfekosadqtw")
    public suspend fun comments(`value`: Output<String>) {
        this.comments = value
    }

    /**
     * @param value The compliance state that should be set on the resource.
     */
    @JvmName("tryafuvjtpkdfqnd")
    public suspend fun complianceState(`value`: Output<Either<String, ComplianceState>>) {
        this.complianceState = value
    }

    /**
     * @param value The evidence supporting the compliance state set in this attestation.
     */
    @JvmName("skvspsmumaphgrgn")
    public suspend fun evidence(`value`: Output<List<AttestationEvidenceArgs>>) {
        this.evidence = value
    }

    @JvmName("byiaicqijriuimlh")
    public suspend fun evidence(vararg values: Output<AttestationEvidenceArgs>) {
        this.evidence = Output.all(values.asList())
    }

    /**
     * @param values The evidence supporting the compliance state set in this attestation.
     */
    @JvmName("tdnrrpmqqmlitmtd")
    public suspend fun evidence(values: List<Output<AttestationEvidenceArgs>>) {
        this.evidence = Output.all(values)
    }

    /**
     * @param value The time the compliance state should expire.
     */
    @JvmName("gqayckmhbigtxcre")
    public suspend fun expiresOn(`value`: Output<String>) {
        this.expiresOn = value
    }

    /**
     * @param value Additional metadata for this attestation
     */
    @JvmName("pxvttjjbxanwiend")
    public suspend fun metadata(`value`: Output<Any>) {
        this.metadata = value
    }

    /**
     * @param value The person responsible for setting the state of the resource. This value is typically an Azure Active Directory object ID.
     */
    @JvmName("gpifhytrbvxkyxme")
    public suspend fun owner(`value`: Output<String>) {
        this.owner = value
    }

    /**
     * @param value The resource ID of the policy assignment that the attestation is setting the state for.
     */
    @JvmName("sotmhncmydrjknaf")
    public suspend fun policyAssignmentId(`value`: Output<String>) {
        this.policyAssignmentId = value
    }

    /**
     * @param value The policy definition reference ID from a policy set definition that the attestation is setting the state for. If the policy assignment assigns a policy set definition the attestation can choose a definition within the set definition with this property or omit this and set the state for the entire set definition.
     */
    @JvmName("pkkpahufgrrndymk")
    public suspend fun policyDefinitionReferenceId(`value`: Output<String>) {
        this.policyDefinitionReferenceId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("aqejjwvnkdjffhys")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The time the evidence was assessed
     */
    @JvmName("pkaunjpnymjsynqm")
    public suspend fun assessmentDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assessmentDate = mapped
    }

    /**
     * @param value The name of the attestation.
     */
    @JvmName("qogglcijtpcjkurb")
    public suspend fun attestationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attestationName = mapped
    }

    /**
     * @param value Comments describing why this attestation was created.
     */
    @JvmName("wnxhwcydaspsqbwt")
    public suspend fun comments(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comments = mapped
    }

    /**
     * @param value The compliance state that should be set on the resource.
     */
    @JvmName("lqxmvcfsdmyyytba")
    public suspend fun complianceState(`value`: Either<String, ComplianceState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.complianceState = mapped
    }

    /**
     * @param value The compliance state that should be set on the resource.
     */
    @JvmName("cnfjjbwuqmseydlw")
    public fun complianceState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ComplianceState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.complianceState = mapped
    }

    /**
     * @param value The compliance state that should be set on the resource.
     */
    @JvmName("krvtfxocpsorpauc")
    public fun complianceState(`value`: ComplianceState) {
        val toBeMapped = Either.ofRight<String, ComplianceState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.complianceState = mapped
    }

    /**
     * @param value The evidence supporting the compliance state set in this attestation.
     */
    @JvmName("hfgjmxnebqkhyekb")
    public suspend fun evidence(`value`: List<AttestationEvidenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.evidence = mapped
    }

    /**
     * @param argument The evidence supporting the compliance state set in this attestation.
     */
    @JvmName("kicqrdgmeunnhbhe")
    public suspend fun evidence(argument: List<suspend AttestationEvidenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AttestationEvidenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.evidence = mapped
    }

    /**
     * @param argument The evidence supporting the compliance state set in this attestation.
     */
    @JvmName("grxxkhawyhsibboa")
    public suspend fun evidence(vararg argument: suspend AttestationEvidenceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AttestationEvidenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.evidence = mapped
    }

    /**
     * @param argument The evidence supporting the compliance state set in this attestation.
     */
    @JvmName("ouusnafdygriitto")
    public suspend fun evidence(argument: suspend AttestationEvidenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AttestationEvidenceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.evidence = mapped
    }

    /**
     * @param values The evidence supporting the compliance state set in this attestation.
     */
    @JvmName("djvhwuonrbexqpib")
    public suspend fun evidence(vararg values: AttestationEvidenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.evidence = mapped
    }

    /**
     * @param value The time the compliance state should expire.
     */
    @JvmName("kpqoapctooyrvqjb")
    public suspend fun expiresOn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expiresOn = mapped
    }

    /**
     * @param value Additional metadata for this attestation
     */
    @JvmName("ytgxmyvsrcytbsht")
    public suspend fun metadata(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value The person responsible for setting the state of the resource. This value is typically an Azure Active Directory object ID.
     */
    @JvmName("jliuapteowmuojuj")
    public suspend fun owner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.owner = mapped
    }

    /**
     * @param value The resource ID of the policy assignment that the attestation is setting the state for.
     */
    @JvmName("ytwdcstkbejvebml")
    public suspend fun policyAssignmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyAssignmentId = mapped
    }

    /**
     * @param value The policy definition reference ID from a policy set definition that the attestation is setting the state for. If the policy assignment assigns a policy set definition the attestation can choose a definition within the set definition with this property or omit this and set the state for the entire set definition.
     */
    @JvmName("aexldhjsoyorqqps")
    public suspend fun policyDefinitionReferenceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDefinitionReferenceId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tqiudrywfwcrpaqt")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): AttestationAtResourceGroupArgs = AttestationAtResourceGroupArgs(
        assessmentDate = assessmentDate,
        attestationName = attestationName,
        comments = comments,
        complianceState = complianceState,
        evidence = evidence,
        expiresOn = expiresOn,
        metadata = metadata,
        owner = owner,
        policyAssignmentId = policyAssignmentId,
        policyDefinitionReferenceId = policyDefinitionReferenceId,
        resourceGroupName = resourceGroupName,
    )
}
