@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.policyinsights.kotlin

import com.pulumi.azurenative.policyinsights.PolicyinsightsFunctions.getAttestationAtResourceGroupPlain
import com.pulumi.azurenative.policyinsights.PolicyinsightsFunctions.getAttestationAtResourcePlain
import com.pulumi.azurenative.policyinsights.PolicyinsightsFunctions.getAttestationAtSubscriptionPlain
import com.pulumi.azurenative.policyinsights.PolicyinsightsFunctions.getRemediationAtManagementGroupPlain
import com.pulumi.azurenative.policyinsights.PolicyinsightsFunctions.getRemediationAtResourceGroupPlain
import com.pulumi.azurenative.policyinsights.PolicyinsightsFunctions.getRemediationAtResourcePlain
import com.pulumi.azurenative.policyinsights.PolicyinsightsFunctions.getRemediationAtSubscriptionPlain
import com.pulumi.azurenative.policyinsights.PolicyinsightsFunctions.listRemediationDeploymentsAtManagementGroupPlain
import com.pulumi.azurenative.policyinsights.PolicyinsightsFunctions.listRemediationDeploymentsAtResourceGroupPlain
import com.pulumi.azurenative.policyinsights.PolicyinsightsFunctions.listRemediationDeploymentsAtResourcePlain
import com.pulumi.azurenative.policyinsights.PolicyinsightsFunctions.listRemediationDeploymentsAtSubscriptionPlain
import com.pulumi.azurenative.policyinsights.kotlin.inputs.GetAttestationAtResourceGroupPlainArgs
import com.pulumi.azurenative.policyinsights.kotlin.inputs.GetAttestationAtResourceGroupPlainArgsBuilder
import com.pulumi.azurenative.policyinsights.kotlin.inputs.GetAttestationAtResourcePlainArgs
import com.pulumi.azurenative.policyinsights.kotlin.inputs.GetAttestationAtResourcePlainArgsBuilder
import com.pulumi.azurenative.policyinsights.kotlin.inputs.GetAttestationAtSubscriptionPlainArgs
import com.pulumi.azurenative.policyinsights.kotlin.inputs.GetAttestationAtSubscriptionPlainArgsBuilder
import com.pulumi.azurenative.policyinsights.kotlin.inputs.GetRemediationAtManagementGroupPlainArgs
import com.pulumi.azurenative.policyinsights.kotlin.inputs.GetRemediationAtManagementGroupPlainArgsBuilder
import com.pulumi.azurenative.policyinsights.kotlin.inputs.GetRemediationAtResourceGroupPlainArgs
import com.pulumi.azurenative.policyinsights.kotlin.inputs.GetRemediationAtResourceGroupPlainArgsBuilder
import com.pulumi.azurenative.policyinsights.kotlin.inputs.GetRemediationAtResourcePlainArgs
import com.pulumi.azurenative.policyinsights.kotlin.inputs.GetRemediationAtResourcePlainArgsBuilder
import com.pulumi.azurenative.policyinsights.kotlin.inputs.GetRemediationAtSubscriptionPlainArgs
import com.pulumi.azurenative.policyinsights.kotlin.inputs.GetRemediationAtSubscriptionPlainArgsBuilder
import com.pulumi.azurenative.policyinsights.kotlin.inputs.ListRemediationDeploymentsAtManagementGroupPlainArgs
import com.pulumi.azurenative.policyinsights.kotlin.inputs.ListRemediationDeploymentsAtManagementGroupPlainArgsBuilder
import com.pulumi.azurenative.policyinsights.kotlin.inputs.ListRemediationDeploymentsAtResourceGroupPlainArgs
import com.pulumi.azurenative.policyinsights.kotlin.inputs.ListRemediationDeploymentsAtResourceGroupPlainArgsBuilder
import com.pulumi.azurenative.policyinsights.kotlin.inputs.ListRemediationDeploymentsAtResourcePlainArgs
import com.pulumi.azurenative.policyinsights.kotlin.inputs.ListRemediationDeploymentsAtResourcePlainArgsBuilder
import com.pulumi.azurenative.policyinsights.kotlin.inputs.ListRemediationDeploymentsAtSubscriptionPlainArgs
import com.pulumi.azurenative.policyinsights.kotlin.inputs.ListRemediationDeploymentsAtSubscriptionPlainArgsBuilder
import com.pulumi.azurenative.policyinsights.kotlin.outputs.GetAttestationAtResourceGroupResult
import com.pulumi.azurenative.policyinsights.kotlin.outputs.GetAttestationAtResourceResult
import com.pulumi.azurenative.policyinsights.kotlin.outputs.GetAttestationAtSubscriptionResult
import com.pulumi.azurenative.policyinsights.kotlin.outputs.GetRemediationAtManagementGroupResult
import com.pulumi.azurenative.policyinsights.kotlin.outputs.GetRemediationAtResourceGroupResult
import com.pulumi.azurenative.policyinsights.kotlin.outputs.GetRemediationAtResourceResult
import com.pulumi.azurenative.policyinsights.kotlin.outputs.GetRemediationAtSubscriptionResult
import com.pulumi.azurenative.policyinsights.kotlin.outputs.ListRemediationDeploymentsAtManagementGroupResult
import com.pulumi.azurenative.policyinsights.kotlin.outputs.ListRemediationDeploymentsAtResourceGroupResult
import com.pulumi.azurenative.policyinsights.kotlin.outputs.ListRemediationDeploymentsAtResourceResult
import com.pulumi.azurenative.policyinsights.kotlin.outputs.ListRemediationDeploymentsAtSubscriptionResult
import kotlinx.coroutines.future.await
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.policyinsights.kotlin.outputs.GetAttestationAtResourceGroupResult.Companion.toKotlin as getAttestationAtResourceGroupResultToKotlin
import com.pulumi.azurenative.policyinsights.kotlin.outputs.GetAttestationAtResourceResult.Companion.toKotlin as getAttestationAtResourceResultToKotlin
import com.pulumi.azurenative.policyinsights.kotlin.outputs.GetAttestationAtSubscriptionResult.Companion.toKotlin as getAttestationAtSubscriptionResultToKotlin
import com.pulumi.azurenative.policyinsights.kotlin.outputs.GetRemediationAtManagementGroupResult.Companion.toKotlin as getRemediationAtManagementGroupResultToKotlin
import com.pulumi.azurenative.policyinsights.kotlin.outputs.GetRemediationAtResourceGroupResult.Companion.toKotlin as getRemediationAtResourceGroupResultToKotlin
import com.pulumi.azurenative.policyinsights.kotlin.outputs.GetRemediationAtResourceResult.Companion.toKotlin as getRemediationAtResourceResultToKotlin
import com.pulumi.azurenative.policyinsights.kotlin.outputs.GetRemediationAtSubscriptionResult.Companion.toKotlin as getRemediationAtSubscriptionResultToKotlin
import com.pulumi.azurenative.policyinsights.kotlin.outputs.ListRemediationDeploymentsAtManagementGroupResult.Companion.toKotlin as listRemediationDeploymentsAtManagementGroupResultToKotlin
import com.pulumi.azurenative.policyinsights.kotlin.outputs.ListRemediationDeploymentsAtResourceGroupResult.Companion.toKotlin as listRemediationDeploymentsAtResourceGroupResultToKotlin
import com.pulumi.azurenative.policyinsights.kotlin.outputs.ListRemediationDeploymentsAtResourceResult.Companion.toKotlin as listRemediationDeploymentsAtResourceResultToKotlin
import com.pulumi.azurenative.policyinsights.kotlin.outputs.ListRemediationDeploymentsAtSubscriptionResult.Companion.toKotlin as listRemediationDeploymentsAtSubscriptionResultToKotlin

public object PolicyinsightsFunctions {
    /**
     * Gets an existing attestation at resource scope.
     * Azure REST API version: 2022-09-01.
     * @param argument null
     * @return An attestation resource.
     */
    public suspend fun getAttestationAtResource(argument: GetAttestationAtResourcePlainArgs): GetAttestationAtResourceResult =
        getAttestationAtResourceResultToKotlin(getAttestationAtResourcePlain(argument.toJava()).await())

    /**
     * @see [getAttestationAtResource].
     * @param attestationName The name of the attestation.
     * @param resourceId Resource ID.
     * @return An attestation resource.
     */
    public suspend fun getAttestationAtResource(attestationName: String, resourceId: String): GetAttestationAtResourceResult {
        val argument = GetAttestationAtResourcePlainArgs(
            attestationName = attestationName,
            resourceId = resourceId,
        )
        return getAttestationAtResourceResultToKotlin(getAttestationAtResourcePlain(argument.toJava()).await())
    }

    /**
     * @see [getAttestationAtResource].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;policyinsights&#46;kotlin&#46;inputs&#46;GetAttestationAtResourcePlainArgs].
     * @return An attestation resource.
     */
    public suspend fun getAttestationAtResource(argument: suspend GetAttestationAtResourcePlainArgsBuilder.() -> Unit): GetAttestationAtResourceResult {
        val builder = GetAttestationAtResourcePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAttestationAtResourceResultToKotlin(getAttestationAtResourcePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an existing attestation at resource group scope.
     * Azure REST API version: 2022-09-01.
     * @param argument null
     * @return An attestation resource.
     */
    public suspend fun getAttestationAtResourceGroup(argument: GetAttestationAtResourceGroupPlainArgs): GetAttestationAtResourceGroupResult =
        getAttestationAtResourceGroupResultToKotlin(getAttestationAtResourceGroupPlain(argument.toJava()).await())

    /**
     * @see [getAttestationAtResourceGroup].
     * @param attestationName The name of the attestation.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An attestation resource.
     */
    public suspend fun getAttestationAtResourceGroup(
        attestationName: String,
        resourceGroupName: String,
    ): GetAttestationAtResourceGroupResult {
        val argument = GetAttestationAtResourceGroupPlainArgs(
            attestationName = attestationName,
            resourceGroupName = resourceGroupName,
        )
        return getAttestationAtResourceGroupResultToKotlin(getAttestationAtResourceGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getAttestationAtResourceGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;policyinsights&#46;kotlin&#46;inputs&#46;GetAttestationAtResourceGroupPlainArgs].
     * @return An attestation resource.
     */
    public suspend fun getAttestationAtResourceGroup(argument: suspend GetAttestationAtResourceGroupPlainArgsBuilder.() -> Unit): GetAttestationAtResourceGroupResult {
        val builder = GetAttestationAtResourceGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAttestationAtResourceGroupResultToKotlin(getAttestationAtResourceGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an existing attestation at subscription scope.
     * Azure REST API version: 2022-09-01.
     * @param argument null
     * @return An attestation resource.
     */
    public suspend fun getAttestationAtSubscription(argument: GetAttestationAtSubscriptionPlainArgs): GetAttestationAtSubscriptionResult =
        getAttestationAtSubscriptionResultToKotlin(getAttestationAtSubscriptionPlain(argument.toJava()).await())

    /**
     * @see [getAttestationAtSubscription].
     * @param attestationName The name of the attestation.
     * @return An attestation resource.
     */
    public suspend fun getAttestationAtSubscription(attestationName: String): GetAttestationAtSubscriptionResult {
        val argument = GetAttestationAtSubscriptionPlainArgs(
            attestationName = attestationName,
        )
        return getAttestationAtSubscriptionResultToKotlin(getAttestationAtSubscriptionPlain(argument.toJava()).await())
    }

    /**
     * @see [getAttestationAtSubscription].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;policyinsights&#46;kotlin&#46;inputs&#46;GetAttestationAtSubscriptionPlainArgs].
     * @return An attestation resource.
     */
    public suspend fun getAttestationAtSubscription(argument: suspend GetAttestationAtSubscriptionPlainArgsBuilder.() -> Unit): GetAttestationAtSubscriptionResult {
        val builder = GetAttestationAtSubscriptionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAttestationAtSubscriptionResultToKotlin(getAttestationAtSubscriptionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an existing remediation at management group scope.
     * Azure REST API version: 2021-10-01.
     * Other available API versions: 2018-07-01-preview.
     * @param argument null
     * @return The remediation definition.
     */
    public suspend fun getRemediationAtManagementGroup(argument: GetRemediationAtManagementGroupPlainArgs): GetRemediationAtManagementGroupResult =
        getRemediationAtManagementGroupResultToKotlin(getRemediationAtManagementGroupPlain(argument.toJava()).await())

    /**
     * @see [getRemediationAtManagementGroup].
     * @param managementGroupId Management group ID.
     * @param managementGroupsNamespace The namespace for Microsoft Management RP; only "Microsoft.Management" is allowed.
     * @param remediationName The name of the remediation.
     * @return The remediation definition.
     */
    public suspend fun getRemediationAtManagementGroup(
        managementGroupId: String,
        managementGroupsNamespace: String,
        remediationName: String,
    ): GetRemediationAtManagementGroupResult {
        val argument = GetRemediationAtManagementGroupPlainArgs(
            managementGroupId = managementGroupId,
            managementGroupsNamespace = managementGroupsNamespace,
            remediationName = remediationName,
        )
        return getRemediationAtManagementGroupResultToKotlin(getRemediationAtManagementGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getRemediationAtManagementGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;policyinsights&#46;kotlin&#46;inputs&#46;GetRemediationAtManagementGroupPlainArgs].
     * @return The remediation definition.
     */
    public suspend fun getRemediationAtManagementGroup(argument: suspend GetRemediationAtManagementGroupPlainArgsBuilder.() -> Unit): GetRemediationAtManagementGroupResult {
        val builder = GetRemediationAtManagementGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRemediationAtManagementGroupResultToKotlin(getRemediationAtManagementGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an existing remediation at resource scope.
     * Azure REST API version: 2021-10-01.
     * Other available API versions: 2018-07-01-preview.
     * @param argument null
     * @return The remediation definition.
     */
    public suspend fun getRemediationAtResource(argument: GetRemediationAtResourcePlainArgs): GetRemediationAtResourceResult =
        getRemediationAtResourceResultToKotlin(getRemediationAtResourcePlain(argument.toJava()).await())

    /**
     * @see [getRemediationAtResource].
     * @param remediationName The name of the remediation.
     * @param resourceId Resource ID.
     * @return The remediation definition.
     */
    public suspend fun getRemediationAtResource(remediationName: String, resourceId: String): GetRemediationAtResourceResult {
        val argument = GetRemediationAtResourcePlainArgs(
            remediationName = remediationName,
            resourceId = resourceId,
        )
        return getRemediationAtResourceResultToKotlin(getRemediationAtResourcePlain(argument.toJava()).await())
    }

    /**
     * @see [getRemediationAtResource].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;policyinsights&#46;kotlin&#46;inputs&#46;GetRemediationAtResourcePlainArgs].
     * @return The remediation definition.
     */
    public suspend fun getRemediationAtResource(argument: suspend GetRemediationAtResourcePlainArgsBuilder.() -> Unit): GetRemediationAtResourceResult {
        val builder = GetRemediationAtResourcePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRemediationAtResourceResultToKotlin(getRemediationAtResourcePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an existing remediation at resource group scope.
     * Azure REST API version: 2021-10-01.
     * Other available API versions: 2018-07-01-preview.
     * @param argument null
     * @return The remediation definition.
     */
    public suspend fun getRemediationAtResourceGroup(argument: GetRemediationAtResourceGroupPlainArgs): GetRemediationAtResourceGroupResult =
        getRemediationAtResourceGroupResultToKotlin(getRemediationAtResourceGroupPlain(argument.toJava()).await())

    /**
     * @see [getRemediationAtResourceGroup].
     * @param remediationName The name of the remediation.
     * @param resourceGroupName Resource group name.
     * @return The remediation definition.
     */
    public suspend fun getRemediationAtResourceGroup(
        remediationName: String,
        resourceGroupName: String,
    ): GetRemediationAtResourceGroupResult {
        val argument = GetRemediationAtResourceGroupPlainArgs(
            remediationName = remediationName,
            resourceGroupName = resourceGroupName,
        )
        return getRemediationAtResourceGroupResultToKotlin(getRemediationAtResourceGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getRemediationAtResourceGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;policyinsights&#46;kotlin&#46;inputs&#46;GetRemediationAtResourceGroupPlainArgs].
     * @return The remediation definition.
     */
    public suspend fun getRemediationAtResourceGroup(argument: suspend GetRemediationAtResourceGroupPlainArgsBuilder.() -> Unit): GetRemediationAtResourceGroupResult {
        val builder = GetRemediationAtResourceGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRemediationAtResourceGroupResultToKotlin(getRemediationAtResourceGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an existing remediation at subscription scope.
     * Azure REST API version: 2021-10-01.
     * Other available API versions: 2018-07-01-preview.
     * @param argument null
     * @return The remediation definition.
     */
    public suspend fun getRemediationAtSubscription(argument: GetRemediationAtSubscriptionPlainArgs): GetRemediationAtSubscriptionResult =
        getRemediationAtSubscriptionResultToKotlin(getRemediationAtSubscriptionPlain(argument.toJava()).await())

    /**
     * @see [getRemediationAtSubscription].
     * @param remediationName The name of the remediation.
     * @return The remediation definition.
     */
    public suspend fun getRemediationAtSubscription(remediationName: String): GetRemediationAtSubscriptionResult {
        val argument = GetRemediationAtSubscriptionPlainArgs(
            remediationName = remediationName,
        )
        return getRemediationAtSubscriptionResultToKotlin(getRemediationAtSubscriptionPlain(argument.toJava()).await())
    }

    /**
     * @see [getRemediationAtSubscription].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;policyinsights&#46;kotlin&#46;inputs&#46;GetRemediationAtSubscriptionPlainArgs].
     * @return The remediation definition.
     */
    public suspend fun getRemediationAtSubscription(argument: suspend GetRemediationAtSubscriptionPlainArgsBuilder.() -> Unit): GetRemediationAtSubscriptionResult {
        val builder = GetRemediationAtSubscriptionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRemediationAtSubscriptionResultToKotlin(getRemediationAtSubscriptionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets all deployments for a remediation at management group scope.
     * Azure REST API version: 2021-10-01.
     * Other available API versions: 2018-07-01-preview.
     * @param argument null
     * @return List of deployments for a remediation.
     */
    public suspend fun listRemediationDeploymentsAtManagementGroup(argument: ListRemediationDeploymentsAtManagementGroupPlainArgs): ListRemediationDeploymentsAtManagementGroupResult =
        listRemediationDeploymentsAtManagementGroupResultToKotlin(listRemediationDeploymentsAtManagementGroupPlain(argument.toJava()).await())

    /**
     * @see [listRemediationDeploymentsAtManagementGroup].
     * @param managementGroupId Management group ID.
     * @param managementGroupsNamespace The namespace for Microsoft Management RP; only "Microsoft.Management" is allowed.
     * @param remediationName The name of the remediation.
     * @param top Maximum number of records to return.
     * @return List of deployments for a remediation.
     */
    public suspend fun listRemediationDeploymentsAtManagementGroup(
        managementGroupId: String,
        managementGroupsNamespace: String,
        remediationName: String,
        top: Int? = null,
    ): ListRemediationDeploymentsAtManagementGroupResult {
        val argument = ListRemediationDeploymentsAtManagementGroupPlainArgs(
            managementGroupId = managementGroupId,
            managementGroupsNamespace = managementGroupsNamespace,
            remediationName = remediationName,
            top = top,
        )
        return listRemediationDeploymentsAtManagementGroupResultToKotlin(listRemediationDeploymentsAtManagementGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [listRemediationDeploymentsAtManagementGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;policyinsights&#46;kotlin&#46;inputs&#46;ListRemediationDeploymentsAtManagementGroupPlainArgs].
     * @return List of deployments for a remediation.
     */
    public suspend fun listRemediationDeploymentsAtManagementGroup(argument: suspend ListRemediationDeploymentsAtManagementGroupPlainArgsBuilder.() -> Unit): ListRemediationDeploymentsAtManagementGroupResult {
        val builder = ListRemediationDeploymentsAtManagementGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listRemediationDeploymentsAtManagementGroupResultToKotlin(listRemediationDeploymentsAtManagementGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets all deployments for a remediation at resource scope.
     * Azure REST API version: 2021-10-01.
     * Other available API versions: 2018-07-01-preview.
     * @param argument null
     * @return List of deployments for a remediation.
     */
    public suspend fun listRemediationDeploymentsAtResource(argument: ListRemediationDeploymentsAtResourcePlainArgs): ListRemediationDeploymentsAtResourceResult =
        listRemediationDeploymentsAtResourceResultToKotlin(listRemediationDeploymentsAtResourcePlain(argument.toJava()).await())

    /**
     * @see [listRemediationDeploymentsAtResource].
     * @param remediationName The name of the remediation.
     * @param resourceId Resource ID.
     * @param top Maximum number of records to return.
     * @return List of deployments for a remediation.
     */
    public suspend fun listRemediationDeploymentsAtResource(
        remediationName: String,
        resourceId: String,
        top: Int? = null,
    ): ListRemediationDeploymentsAtResourceResult {
        val argument = ListRemediationDeploymentsAtResourcePlainArgs(
            remediationName = remediationName,
            resourceId = resourceId,
            top = top,
        )
        return listRemediationDeploymentsAtResourceResultToKotlin(listRemediationDeploymentsAtResourcePlain(argument.toJava()).await())
    }

    /**
     * @see [listRemediationDeploymentsAtResource].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;policyinsights&#46;kotlin&#46;inputs&#46;ListRemediationDeploymentsAtResourcePlainArgs].
     * @return List of deployments for a remediation.
     */
    public suspend fun listRemediationDeploymentsAtResource(argument: suspend ListRemediationDeploymentsAtResourcePlainArgsBuilder.() -> Unit): ListRemediationDeploymentsAtResourceResult {
        val builder = ListRemediationDeploymentsAtResourcePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listRemediationDeploymentsAtResourceResultToKotlin(listRemediationDeploymentsAtResourcePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets all deployments for a remediation at resource group scope.
     * Azure REST API version: 2021-10-01.
     * Other available API versions: 2018-07-01-preview.
     * @param argument null
     * @return List of deployments for a remediation.
     */
    public suspend fun listRemediationDeploymentsAtResourceGroup(argument: ListRemediationDeploymentsAtResourceGroupPlainArgs): ListRemediationDeploymentsAtResourceGroupResult =
        listRemediationDeploymentsAtResourceGroupResultToKotlin(listRemediationDeploymentsAtResourceGroupPlain(argument.toJava()).await())

    /**
     * @see [listRemediationDeploymentsAtResourceGroup].
     * @param remediationName The name of the remediation.
     * @param resourceGroupName Resource group name.
     * @param top Maximum number of records to return.
     * @return List of deployments for a remediation.
     */
    public suspend fun listRemediationDeploymentsAtResourceGroup(
        remediationName: String,
        resourceGroupName: String,
        top: Int? = null,
    ): ListRemediationDeploymentsAtResourceGroupResult {
        val argument = ListRemediationDeploymentsAtResourceGroupPlainArgs(
            remediationName = remediationName,
            resourceGroupName = resourceGroupName,
            top = top,
        )
        return listRemediationDeploymentsAtResourceGroupResultToKotlin(listRemediationDeploymentsAtResourceGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [listRemediationDeploymentsAtResourceGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;policyinsights&#46;kotlin&#46;inputs&#46;ListRemediationDeploymentsAtResourceGroupPlainArgs].
     * @return List of deployments for a remediation.
     */
    public suspend fun listRemediationDeploymentsAtResourceGroup(argument: suspend ListRemediationDeploymentsAtResourceGroupPlainArgsBuilder.() -> Unit): ListRemediationDeploymentsAtResourceGroupResult {
        val builder = ListRemediationDeploymentsAtResourceGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listRemediationDeploymentsAtResourceGroupResultToKotlin(listRemediationDeploymentsAtResourceGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets all deployments for a remediation at subscription scope.
     * Azure REST API version: 2021-10-01.
     * Other available API versions: 2018-07-01-preview.
     * @param argument null
     * @return List of deployments for a remediation.
     */
    public suspend fun listRemediationDeploymentsAtSubscription(argument: ListRemediationDeploymentsAtSubscriptionPlainArgs): ListRemediationDeploymentsAtSubscriptionResult =
        listRemediationDeploymentsAtSubscriptionResultToKotlin(listRemediationDeploymentsAtSubscriptionPlain(argument.toJava()).await())

    /**
     * @see [listRemediationDeploymentsAtSubscription].
     * @param remediationName The name of the remediation.
     * @param top Maximum number of records to return.
     * @return List of deployments for a remediation.
     */
    public suspend fun listRemediationDeploymentsAtSubscription(
        remediationName: String,
        top: Int? =
            null,
    ): ListRemediationDeploymentsAtSubscriptionResult {
        val argument = ListRemediationDeploymentsAtSubscriptionPlainArgs(
            remediationName = remediationName,
            top = top,
        )
        return listRemediationDeploymentsAtSubscriptionResultToKotlin(listRemediationDeploymentsAtSubscriptionPlain(argument.toJava()).await())
    }

    /**
     * @see [listRemediationDeploymentsAtSubscription].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;policyinsights&#46;kotlin&#46;inputs&#46;ListRemediationDeploymentsAtSubscriptionPlainArgs].
     * @return List of deployments for a remediation.
     */
    public suspend fun listRemediationDeploymentsAtSubscription(argument: suspend ListRemediationDeploymentsAtSubscriptionPlainArgsBuilder.() -> Unit): ListRemediationDeploymentsAtSubscriptionResult {
        val builder = ListRemediationDeploymentsAtSubscriptionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listRemediationDeploymentsAtSubscriptionResultToKotlin(listRemediationDeploymentsAtSubscriptionPlain(builtArgument.toJava()).await())
    }
}
