@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.policyinsights.kotlin

import com.pulumi.azurenative.policyinsights.kotlin.outputs.RemediationDeploymentSummaryResponse
import com.pulumi.azurenative.policyinsights.kotlin.outputs.RemediationFiltersResponse
import com.pulumi.azurenative.policyinsights.kotlin.outputs.RemediationPropertiesResponseFailureThreshold
import com.pulumi.azurenative.policyinsights.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.policyinsights.kotlin.outputs.RemediationDeploymentSummaryResponse.Companion.toKotlin as remediationDeploymentSummaryResponseToKotlin
import com.pulumi.azurenative.policyinsights.kotlin.outputs.RemediationFiltersResponse.Companion.toKotlin as remediationFiltersResponseToKotlin
import com.pulumi.azurenative.policyinsights.kotlin.outputs.RemediationPropertiesResponseFailureThreshold.Companion.toKotlin as remediationPropertiesResponseFailureThresholdToKotlin
import com.pulumi.azurenative.policyinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [RemediationAtManagementGroup].
 */
@PulumiTagMarker
public class RemediationAtManagementGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RemediationAtManagementGroupArgs = RemediationAtManagementGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RemediationAtManagementGroupArgsBuilder.() -> Unit) {
        val builder = RemediationAtManagementGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RemediationAtManagementGroup {
        val builtJavaResource =
            com.pulumi.azurenative.policyinsights.RemediationAtManagementGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return RemediationAtManagementGroup(builtJavaResource)
    }
}

/**
 * The remediation definition.
 * Azure REST API version: 2021-10-01. Prior API version in Azure Native 1.x: 2019-07-01.
 * Other available API versions: 2018-07-01-preview.
 * ## Example Usage
 * ### Create remediation at management group scope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var remediationAtManagementGroup = new AzureNative.PolicyInsights.RemediationAtManagementGroup("remediationAtManagementGroup", new()
 *     {
 *         ManagementGroupId = "financeMg",
 *         ManagementGroupsNamespace = "Microsoft.Management",
 *         PolicyAssignmentId = "/providers/microsoft.management/managementGroups/financeMg/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5",
 *         RemediationName = "storageRemediation",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/policyinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := policyinsights.NewRemediationAtManagementGroup(ctx, "remediationAtManagementGroup", &policyinsights.RemediationAtManagementGroupArgs{
 * 			ManagementGroupId:         pulumi.String("financeMg"),
 * 			ManagementGroupsNamespace: pulumi.String("Microsoft.Management"),
 * 			PolicyAssignmentId:        pulumi.String("/providers/microsoft.management/managementGroups/financeMg/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
 * 			RemediationName:           pulumi.String("storageRemediation"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.policyinsights.RemediationAtManagementGroup;
 * import com.pulumi.azurenative.policyinsights.RemediationAtManagementGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var remediationAtManagementGroup = new RemediationAtManagementGroup("remediationAtManagementGroup", RemediationAtManagementGroupArgs.builder()
 *             .managementGroupId("financeMg")
 *             .managementGroupsNamespace("Microsoft.Management")
 *             .policyAssignmentId("/providers/microsoft.management/managementGroups/financeMg/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5")
 *             .remediationName("storageRemediation")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:policyinsights:RemediationAtManagementGroup storageRemediation /providers/{managementGroupsNamespace}/managementGroups/{managementGroupId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}
 * ```
 */
public class RemediationAtManagementGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.policyinsights.RemediationAtManagementGroup,
) : KotlinCustomResource(javaResource, RemediationAtManagementGroupMapper) {
    /**
     * The remediation correlation Id. Can be used to find events related to the remediation in the activity log.
     */
    public val correlationId: Output<String>
        get() = javaResource.correlationId().applyValue({ args0 -> args0 })

    /**
     * The time at which the remediation was created.
     */
    public val createdOn: Output<String>
        get() = javaResource.createdOn().applyValue({ args0 -> args0 })

    /**
     * The deployment status summary for all deployments created by the remediation.
     */
    public val deploymentStatus: Output<RemediationDeploymentSummaryResponse>
        get() = javaResource.deploymentStatus().applyValue({ args0 ->
            args0.let({ args0 ->
                remediationDeploymentSummaryResponseToKotlin(args0)
            })
        })

    /**
     * The remediation failure threshold settings
     */
    public val failureThreshold: Output<RemediationPropertiesResponseFailureThreshold>?
        get() = javaResource.failureThreshold().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    remediationPropertiesResponseFailureThresholdToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The filters that will be applied to determine which resources to remediate.
     */
    public val filters: Output<RemediationFiltersResponse>?
        get() = javaResource.filters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    remediationFiltersResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The time at which the remediation was last updated.
     */
    public val lastUpdatedOn: Output<String>
        get() = javaResource.lastUpdatedOn().applyValue({ args0 -> args0 })

    /**
     * The name of the remediation.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Determines how many resources to remediate at any given time. Can be used to increase or reduce the pace of the remediation. If not provided, the default parallel deployments value is used.
     */
    public val parallelDeployments: Output<Int>?
        get() = javaResource.parallelDeployments().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The resource ID of the policy assignment that should be remediated.
     */
    public val policyAssignmentId: Output<String>?
        get() = javaResource.policyAssignmentId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The policy definition reference ID of the individual definition that should be remediated. Required when the policy assignment being remediated assigns a policy set definition.
     */
    public val policyDefinitionReferenceId: Output<String>?
        get() = javaResource.policyDefinitionReferenceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of the remediation. This refers to the entire remediation task, not individual deployments. Allowed values are Evaluating, Canceled, Cancelling, Failed, Complete, or Succeeded.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Determines the max number of resources that can be remediated by the remediation job. If not provided, the default resource count is used.
     */
    public val resourceCount: Output<Int>?
        get() = javaResource.resourceCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The way resources to remediate are discovered. Defaults to ExistingNonCompliant if not specified.
     */
    public val resourceDiscoveryMode: Output<String>?
        get() = javaResource.resourceDiscoveryMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The remediation status message. Provides additional details regarding the state of the remediation.
     */
    public val statusMessage: Output<String>
        get() = javaResource.statusMessage().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the remediation.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RemediationAtManagementGroupMapper : ResourceMapper<RemediationAtManagementGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.policyinsights.RemediationAtManagementGroup::class == javaResource::class

    override fun map(javaResource: Resource): RemediationAtManagementGroup =
        RemediationAtManagementGroup(
            javaResource as
                com.pulumi.azurenative.policyinsights.RemediationAtManagementGroup,
        )
}

/**
 * @see [RemediationAtManagementGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RemediationAtManagementGroup].
 */
public suspend fun remediationAtManagementGroup(
    name: String,
    block: suspend RemediationAtManagementGroupResourceBuilder.() -> Unit,
): RemediationAtManagementGroup {
    val builder = RemediationAtManagementGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RemediationAtManagementGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun remediationAtManagementGroup(name: String): RemediationAtManagementGroup {
    val builder = RemediationAtManagementGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
