@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.policyinsights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The compliance state that should be set on the resource.
 */
public enum class ComplianceState(
    public val javaValue: com.pulumi.azurenative.policyinsights.enums.ComplianceState,
) : ConvertibleToJava<com.pulumi.azurenative.policyinsights.enums.ComplianceState> {
    /**
     * The resource is in compliance with the policy.
     */
    Compliant(com.pulumi.azurenative.policyinsights.enums.ComplianceState.Compliant),

    /**
     * The resource is not in compliance with the policy.
     */
    NonCompliant(com.pulumi.azurenative.policyinsights.enums.ComplianceState.NonCompliant),

    /**
     * The compliance state of the resource is not known.
     */
    Unknown(com.pulumi.azurenative.policyinsights.enums.ComplianceState.Unknown),
    ;

    override fun toJava(): com.pulumi.azurenative.policyinsights.enums.ComplianceState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.policyinsights.enums.ComplianceState): ComplianceState = ComplianceState.values().first { it.javaValue == javaType }
    }
}
