@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.policyinsights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The way resources to remediate are discovered. Defaults to ExistingNonCompliant if not specified.
 */
public enum class ResourceDiscoveryMode(
    public val javaValue: com.pulumi.azurenative.policyinsights.enums.ResourceDiscoveryMode,
) : ConvertibleToJava<com.pulumi.azurenative.policyinsights.enums.ResourceDiscoveryMode> {
    /**
     * Remediate resources that are already known to be non-compliant.
     */
    ExistingNonCompliant(com.pulumi.azurenative.policyinsights.enums.ResourceDiscoveryMode.ExistingNonCompliant),

    /**
     * Re-evaluate the compliance state of resources and then remediate the resources found to be non-compliant.
     */
    ReEvaluateCompliance(com.pulumi.azurenative.policyinsights.enums.ResourceDiscoveryMode.ReEvaluateCompliance),
    ;

    override fun toJava(): com.pulumi.azurenative.policyinsights.enums.ResourceDiscoveryMode =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.policyinsights.enums.ResourceDiscoveryMode): ResourceDiscoveryMode = ResourceDiscoveryMode.values().first { it.javaValue == javaType }
    }
}
