@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.policyinsights.kotlin.inputs

import com.pulumi.azurenative.policyinsights.inputs.ListRemediationDeploymentsAtSubscriptionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property remediationName The name of the remediation.
 * @property top Maximum number of records to return.
 */
public data class ListRemediationDeploymentsAtSubscriptionPlainArgs(
    public val remediationName: String,
    public val top: Int? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.policyinsights.inputs.ListRemediationDeploymentsAtSubscriptionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.policyinsights.inputs.ListRemediationDeploymentsAtSubscriptionPlainArgs =
        com.pulumi.azurenative.policyinsights.inputs.ListRemediationDeploymentsAtSubscriptionPlainArgs.builder()
            .remediationName(remediationName.let({ args0 -> args0 }))
            .top(top?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListRemediationDeploymentsAtSubscriptionPlainArgs].
 */
@PulumiTagMarker
public class ListRemediationDeploymentsAtSubscriptionPlainArgsBuilder internal constructor() {
    private var remediationName: String? = null

    private var top: Int? = null

    /**
     * @param value The name of the remediation.
     */
    @JvmName("lkcgttyprkwpuxpl")
    public suspend fun remediationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.remediationName = mapped
    }

    /**
     * @param value Maximum number of records to return.
     */
    @JvmName("gvsaughngevfyina")
    public suspend fun top(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.top = mapped
    }

    internal fun build(): ListRemediationDeploymentsAtSubscriptionPlainArgs =
        ListRemediationDeploymentsAtSubscriptionPlainArgs(
            remediationName = remediationName ?: throw PulumiNullFieldException("remediationName"),
            top = top,
        )
}
