@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.policyinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A piece of evidence supporting the compliance state set in the attestation.
 * @property description The description for this piece of evidence.
 * @property sourceUri The URI location of the evidence.
 */
public data class AttestationEvidenceResponse(
    public val description: String? = null,
    public val sourceUri: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.policyinsights.outputs.AttestationEvidenceResponse): AttestationEvidenceResponse = AttestationEvidenceResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            sourceUri = javaType.sourceUri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
