@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.policyinsights.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The remediation definition.
 * @property correlationId The remediation correlation Id. Can be used to find events related to the remediation in the activity log.
 * @property createdOn The time at which the remediation was created.
 * @property deploymentStatus The deployment status summary for all deployments created by the remediation.
 * @property failureThreshold The remediation failure threshold settings
 * @property filters The filters that will be applied to determine which resources to remediate.
 * @property id The ID of the remediation.
 * @property lastUpdatedOn The time at which the remediation was last updated.
 * @property name The name of the remediation.
 * @property parallelDeployments Determines how many resources to remediate at any given time. Can be used to increase or reduce the pace of the remediation. If not provided, the default parallel deployments value is used.
 * @property policyAssignmentId The resource ID of the policy assignment that should be remediated.
 * @property policyDefinitionReferenceId The policy definition reference ID of the individual definition that should be remediated. Required when the policy assignment being remediated assigns a policy set definition.
 * @property provisioningState The status of the remediation. This refers to the entire remediation task, not individual deployments. Allowed values are Evaluating, Canceled, Cancelling, Failed, Complete, or Succeeded.
 * @property resourceCount Determines the max number of resources that can be remediated by the remediation job. If not provided, the default resource count is used.
 * @property resourceDiscoveryMode The way resources to remediate are discovered. Defaults to ExistingNonCompliant if not specified.
 * @property statusMessage The remediation status message. Provides additional details regarding the state of the remediation.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the remediation.
 */
public data class GetRemediationAtSubscriptionResult(
    public val correlationId: String,
    public val createdOn: String,
    public val deploymentStatus: RemediationDeploymentSummaryResponse,
    public val failureThreshold: RemediationPropertiesResponseFailureThreshold? = null,
    public val filters: RemediationFiltersResponse? = null,
    public val id: String,
    public val lastUpdatedOn: String,
    public val name: String,
    public val parallelDeployments: Int? = null,
    public val policyAssignmentId: String? = null,
    public val policyDefinitionReferenceId: String? = null,
    public val provisioningState: String,
    public val resourceCount: Int? = null,
    public val resourceDiscoveryMode: String? = null,
    public val statusMessage: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.policyinsights.outputs.GetRemediationAtSubscriptionResult): GetRemediationAtSubscriptionResult = GetRemediationAtSubscriptionResult(
            correlationId = javaType.correlationId(),
            createdOn = javaType.createdOn(),
            deploymentStatus = javaType.deploymentStatus().let({ args0 ->
                com.pulumi.azurenative.policyinsights.kotlin.outputs.RemediationDeploymentSummaryResponse.Companion.toKotlin(args0)
            }),
            failureThreshold = javaType.failureThreshold().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.policyinsights.kotlin.outputs.RemediationPropertiesResponseFailureThreshold.Companion.toKotlin(args0)
                })
            }).orElse(null),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.policyinsights.kotlin.outputs.RemediationFiltersResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            lastUpdatedOn = javaType.lastUpdatedOn(),
            name = javaType.name(),
            parallelDeployments = javaType.parallelDeployments().map({ args0 -> args0 }).orElse(null),
            policyAssignmentId = javaType.policyAssignmentId().map({ args0 -> args0 }).orElse(null),
            policyDefinitionReferenceId = javaType.policyDefinitionReferenceId().map({ args0 ->
                args0
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            resourceCount = javaType.resourceCount().map({ args0 -> args0 }).orElse(null),
            resourceDiscoveryMode = javaType.resourceDiscoveryMode().map({ args0 -> args0 }).orElse(null),
            statusMessage = javaType.statusMessage(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.policyinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
