@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.policyinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * List of deployments for a remediation.
 * @property nextLink The URL to get the next set of results.
 * @property value Array of deployments for the remediation.
 */
public data class ListRemediationDeploymentsAtSubscriptionResult(
    public val nextLink: String,
    public val `value`: List<RemediationDeploymentResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.policyinsights.outputs.ListRemediationDeploymentsAtSubscriptionResult): ListRemediationDeploymentsAtSubscriptionResult =
            ListRemediationDeploymentsAtSubscriptionResult(
                nextLink = javaType.nextLink(),
                `value` = javaType.`value`().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.policyinsights.kotlin.outputs.RemediationDeploymentResponse.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
