@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.policyinsights.kotlin.outputs

import kotlin.Double
import kotlin.Suppress

/**
 * The remediation failure threshold settings
 * @property percentage A number between 0.0 to 1.0 representing the percentage failure threshold. The remediation will fail if the percentage of failed remediation operations (i.e. failed deployments) exceeds this threshold.
 */
public data class RemediationPropertiesResponseFailureThreshold(
    public val percentage: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.policyinsights.outputs.RemediationPropertiesResponseFailureThreshold): RemediationPropertiesResponseFailureThreshold =
            RemediationPropertiesResponseFailureThreshold(
                percentage = javaType.percentage().map({ args0 -> args0 }).orElse(null),
            )
    }
}
