@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin

import com.pulumi.azurenative.portal.DashboardArgs.builder
import com.pulumi.azurenative.portal.kotlin.inputs.DashboardLensArgs
import com.pulumi.azurenative.portal.kotlin.inputs.DashboardLensArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The shared dashboard resource definition.
 * Azure REST API version: 2020-09-01-preview. Prior API version in Azure Native 1.x: 2020-09-01-preview.
 * Other available API versions: 2019-01-01-preview.
 * ## Example Usage
 * ### Create or update a Dashboard
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dashboard = new AzureNative.Portal.Dashboard("dashboard", new()
 *     {
 *         DashboardName = "testDashboard",
 *         Lenses = new[]
 *         {
 *             new AzureNative.Portal.Inputs.DashboardLensArgs
 *             {
 *                 Order = 1,
 *                 Parts = new[]
 *                 {
 *                     new AzureNative.Portal.Inputs.DashboardPartsArgs
 *                     {
 *                         Position = new AzureNative.Portal.Inputs.DashboardPartsPositionArgs
 *                         {
 *                             ColSpan = 3,
 *                             RowSpan = 4,
 *                             X = 1,
 *                             Y = 2,
 *                         },
 *                     },
 *                     new AzureNative.Portal.Inputs.DashboardPartsArgs
 *                     {
 *                         Position = new AzureNative.Portal.Inputs.DashboardPartsPositionArgs
 *                         {
 *                             ColSpan = 6,
 *                             RowSpan = 6,
 *                             X = 5,
 *                             Y = 5,
 *                         },
 *                     },
 *                 },
 *             },
 *             new AzureNative.Portal.Inputs.DashboardLensArgs
 *             {
 *                 Order = 2,
 *                 Parts = new() { },
 *             },
 *         },
 *         Location = "eastus",
 *         Metadata =
 *         {
 *             { "metadata", new Dictionary<string, object?>
 *             {
 *                 ["ColSpan"] = 2,
 *                 ["RowSpan"] = 1,
 *                 ["X"] = 4,
 *                 ["Y"] = 3,
 *             } },
 *         },
 *         ResourceGroupName = "testRG",
 *         Tags =
 *         {
 *             { "aKey", "aValue" },
 *             { "anotherKey", "anotherValue" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/portal/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := portal.NewDashboard(ctx, "dashboard", &portal.DashboardArgs{
 * 			DashboardName: pulumi.String("testDashboard"),
 * 			Lenses: portal.DashboardLensArray{
 * 				&portal.DashboardLensArgs{
 * 					Order: pulumi.Int(1),
 * 					Parts: []portal.DashboardPartsArgs{
 * 						{
 * 							Position: {
 * 								ColSpan: pulumi.Int(3),
 * 								RowSpan: pulumi.Int(4),
 * 								X:       pulumi.Int(1),
 * 								Y:       pulumi.Int(2),
 * 							},
 * 						},
 * 						{
 * 							Position: {
 * 								ColSpan: pulumi.Int(6),
 * 								RowSpan: pulumi.Int(6),
 * 								X:       pulumi.Int(5),
 * 								Y:       pulumi.Int(5),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				&portal.DashboardLensArgs{
 * 					Order: pulumi.Int(2),
 * 					Parts: portal.DashboardPartsArray{},
 * 				},
 * 			},
 * 			Location: pulumi.String("eastus"),
 * 			Metadata: pulumi.Map{
 * 				"metadata": pulumi.Any(map[string]interface{}{
 * 					"ColSpan": 2,
 * 					"RowSpan": 1,
 * 					"X":       4,
 * 					"Y":       3,
 * 				}),
 * 			},
 * 			ResourceGroupName: pulumi.String("testRG"),
 * 			Tags: pulumi.StringMap{
 * 				"aKey":       pulumi.String("aValue"),
 * 				"anotherKey": pulumi.String("anotherValue"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.portal.Dashboard;
 * import com.pulumi.azurenative.portal.DashboardArgs;
 * import com.pulumi.azurenative.portal.inputs.DashboardLensArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dashboard = new Dashboard("dashboard", DashboardArgs.builder()
 *             .dashboardName("testDashboard")
 *             .lenses(
 *                 DashboardLensArgs.builder()
 *                     .order(1)
 *                     .parts(
 *                         DashboardPartsArgs.builder()
 *                             .position(DashboardPartsPositionArgs.builder()
 *                                 .colSpan(3)
 *                                 .rowSpan(4)
 *                                 .x(1)
 *                                 .y(2)
 *                                 .build())
 *                             .build(),
 *                         DashboardPartsArgs.builder()
 *                             .position(DashboardPartsPositionArgs.builder()
 *                                 .colSpan(6)
 *                                 .rowSpan(6)
 *                                 .x(5)
 *                                 .y(5)
 *                                 .build())
 *                             .build())
 *                     .build(),
 *                 DashboardLensArgs.builder()
 *                     .order(2)
 *                     .parts()
 *                     .build())
 *             .location("eastus")
 *             .metadata(Map.of("metadata", Map.ofEntries(
 *                 Map.entry("ColSpan", 2),
 *                 Map.entry("RowSpan", 1),
 *                 Map.entry("X", 4),
 *                 Map.entry("Y", 3)
 *             )))
 *             .resourceGroupName("testRG")
 *             .tags(Map.ofEntries(
 *                 Map.entry("aKey", "aValue"),
 *                 Map.entry("anotherKey", "anotherValue")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:portal:Dashboard testDashboard /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Portal/dashboards/{dashboardName}
 * ```
 * @property dashboardName The name of the dashboard.
 * @property lenses The dashboard lenses.
 * @property location Resource location
 * @property metadata The dashboard metadata.
 * @property resourceGroupName The name of the resource group.
 * @property tags Resource tags
 */
public data class DashboardArgs(
    public val dashboardName: Output<String>? = null,
    public val lenses: Output<List<DashboardLensArgs>>? = null,
    public val location: Output<String>? = null,
    public val metadata: Output<Map<String, Any>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.portal.DashboardArgs> {
    override fun toJava(): com.pulumi.azurenative.portal.DashboardArgs =
        com.pulumi.azurenative.portal.DashboardArgs.builder()
            .dashboardName(dashboardName?.applyValue({ args0 -> args0 }))
            .lenses(lenses?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .metadata(
                metadata?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DashboardArgs].
 */
@PulumiTagMarker
public class DashboardArgsBuilder internal constructor() {
    private var dashboardName: Output<String>? = null

    private var lenses: Output<List<DashboardLensArgs>>? = null

    private var location: Output<String>? = null

    private var metadata: Output<Map<String, Any>>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the dashboard.
     */
    @JvmName("jwwxgyscmnpobjfr")
    public suspend fun dashboardName(`value`: Output<String>) {
        this.dashboardName = value
    }

    /**
     * @param value The dashboard lenses.
     */
    @JvmName("wgiarpdhoghjoxnr")
    public suspend fun lenses(`value`: Output<List<DashboardLensArgs>>) {
        this.lenses = value
    }

    @JvmName("swtavjhqrukwbkie")
    public suspend fun lenses(vararg values: Output<DashboardLensArgs>) {
        this.lenses = Output.all(values.asList())
    }

    /**
     * @param values The dashboard lenses.
     */
    @JvmName("egwdjyyuclgsgmvd")
    public suspend fun lenses(values: List<Output<DashboardLensArgs>>) {
        this.lenses = Output.all(values)
    }

    /**
     * @param value Resource location
     */
    @JvmName("epnrrganbcjnkuff")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The dashboard metadata.
     */
    @JvmName("xmncdvamrwroyfsl")
    public suspend fun metadata(`value`: Output<Map<String, Any>>) {
        this.metadata = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ucxhuxwgvjaphjbm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("prjeblawtlaoobyw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the dashboard.
     */
    @JvmName("vadhnihusvbwexfc")
    public suspend fun dashboardName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dashboardName = mapped
    }

    /**
     * @param value The dashboard lenses.
     */
    @JvmName("yviyyllbbuyteldt")
    public suspend fun lenses(`value`: List<DashboardLensArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lenses = mapped
    }

    /**
     * @param argument The dashboard lenses.
     */
    @JvmName("wfejapihepnxybkm")
    public suspend fun lenses(argument: List<suspend DashboardLensArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DashboardLensArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.lenses = mapped
    }

    /**
     * @param argument The dashboard lenses.
     */
    @JvmName("qpyssoerhhngffna")
    public suspend fun lenses(vararg argument: suspend DashboardLensArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DashboardLensArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.lenses = mapped
    }

    /**
     * @param argument The dashboard lenses.
     */
    @JvmName("vpsjjojabribybsp")
    public suspend fun lenses(argument: suspend DashboardLensArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DashboardLensArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.lenses = mapped
    }

    /**
     * @param values The dashboard lenses.
     */
    @JvmName("fbpqjfilkggcbovs")
    public suspend fun lenses(vararg values: DashboardLensArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lenses = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("aoxyfydyyapntpic")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The dashboard metadata.
     */
    @JvmName("gvibxdwbyoduafbf")
    public suspend fun metadata(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param values The dashboard metadata.
     */
    @JvmName("mcxdpmheibruwlei")
    public fun metadata(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("tlnylpgndarvkgfi")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("nhcwsnnfevsfnckw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("xevdqmpnlmgkdhot")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DashboardArgs = DashboardArgs(
        dashboardName = dashboardName,
        lenses = lenses,
        location = location,
        metadata = metadata,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
