@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin

import com.pulumi.azurenative.portal.UserSettingsArgs.builder
import com.pulumi.azurenative.portal.kotlin.inputs.UserPropertiesArgs
import com.pulumi.azurenative.portal.kotlin.inputs.UserPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Response to get user settings
 * Azure REST API version: 2018-10-01. Prior API version in Azure Native 1.x: 2018-10-01.
 * ## Example Usage
 * ### PutUserSettings
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var userSettings = new AzureNative.Portal.UserSettings("userSettings", new()
 *     {
 *         Properties = new AzureNative.Portal.Inputs.UserPropertiesArgs
 *         {
 *             PreferredLocation = "eastus",
 *             PreferredOsType = AzureNative.Portal.OsType.Linux,
 *             PreferredShellType = AzureNative.Portal.ShellType.Bash,
 *             StorageProfile = new AzureNative.Portal.Inputs.StorageProfileArgs
 *             {
 *                 DiskSizeInGB = 5,
 *                 FileShareName = "string",
 *                 StorageAccountResourceId = "string",
 *             },
 *             TerminalSettings = new AzureNative.Portal.Inputs.TerminalSettingsArgs
 *             {
 *                 FontSize = AzureNative.Portal.FontSize.Medium,
 *                 FontStyle = AzureNative.Portal.FontStyle.Monospace,
 *             },
 *         },
 *         UserSettingsName = "cloudconsole",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/portal/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := portal.NewUserSettings(ctx, "userSettings", &portal.UserSettingsArgs{
 * 			Properties: &portal.UserPropertiesArgs{
 * 				PreferredLocation:  pulumi.String("eastus"),
 * 				PreferredOsType:    pulumi.String(portal.OsTypeLinux),
 * 				PreferredShellType: pulumi.String(portal.ShellTypeBash),
 * 				StorageProfile: &portal.StorageProfileArgs{
 * 					DiskSizeInGB:             pulumi.Int(5),
 * 					FileShareName:            pulumi.String("string"),
 * 					StorageAccountResourceId: pulumi.String("string"),
 * 				},
 * 				TerminalSettings: &portal.TerminalSettingsArgs{
 * 					FontSize:  pulumi.String(portal.FontSizeMedium),
 * 					FontStyle: pulumi.String(portal.FontStyleMonospace),
 * 				},
 * 			},
 * 			UserSettingsName: pulumi.String("cloudconsole"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.portal.UserSettings;
 * import com.pulumi.azurenative.portal.UserSettingsArgs;
 * import com.pulumi.azurenative.portal.inputs.UserPropertiesArgs;
 * import com.pulumi.azurenative.portal.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.portal.inputs.TerminalSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var userSettings = new UserSettings("userSettings", UserSettingsArgs.builder()
 *             .properties(UserPropertiesArgs.builder()
 *                 .preferredLocation("eastus")
 *                 .preferredOsType("Linux")
 *                 .preferredShellType("bash")
 *                 .storageProfile(StorageProfileArgs.builder()
 *                     .diskSizeInGB(5)
 *                     .fileShareName("string")
 *                     .storageAccountResourceId("string")
 *                     .build())
 *                 .terminalSettings(TerminalSettingsArgs.builder()
 *                     .fontSize("Medium")
 *                     .fontStyle("Monospace")
 *                     .build())
 *                 .build())
 *             .userSettingsName("cloudconsole")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:portal:UserSettings myresource1 /providers/Microsoft.Portal/userSettings/{userSettingsName}
 * ```
 * @property properties The cloud shell user settings properties.
 * @property userSettingsName The name of the user settings
 */
public data class UserSettingsArgs(
    public val properties: Output<UserPropertiesArgs>? = null,
    public val userSettingsName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.portal.UserSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.portal.UserSettingsArgs =
        com.pulumi.azurenative.portal.UserSettingsArgs.builder()
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .userSettingsName(userSettingsName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserSettingsArgs].
 */
@PulumiTagMarker
public class UserSettingsArgsBuilder internal constructor() {
    private var properties: Output<UserPropertiesArgs>? = null

    private var userSettingsName: Output<String>? = null

    /**
     * @param value The cloud shell user settings properties.
     */
    @JvmName("vgpgbpoxcabkdgfa")
    public suspend fun properties(`value`: Output<UserPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the user settings
     */
    @JvmName("hyouhwiovlhdbnfn")
    public suspend fun userSettingsName(`value`: Output<String>) {
        this.userSettingsName = value
    }

    /**
     * @param value The cloud shell user settings properties.
     */
    @JvmName("useuuasbaakilabx")
    public suspend fun properties(`value`: UserPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The cloud shell user settings properties.
     */
    @JvmName("sidqmsxpvxaexxui")
    public suspend fun properties(argument: suspend UserPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = UserPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the user settings
     */
    @JvmName("pfrwgjbqbcwyiyor")
    public suspend fun userSettingsName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userSettingsName = mapped
    }

    internal fun build(): UserSettingsArgs = UserSettingsArgs(
        properties = properties,
        userSettingsName = userSettingsName,
    )
}
