@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The shell type of the cloud shell.
 */
public enum class ShellType(
    public val javaValue: com.pulumi.azurenative.portal.enums.ShellType,
) : ConvertibleToJava<com.pulumi.azurenative.portal.enums.ShellType> {
    Bash(com.pulumi.azurenative.portal.enums.ShellType.Bash),
    Pwsh(com.pulumi.azurenative.portal.enums.ShellType.Pwsh),
    Powershell(com.pulumi.azurenative.portal.enums.ShellType.Powershell),
    ;

    override fun toJava(): com.pulumi.azurenative.portal.enums.ShellType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.portal.enums.ShellType): ShellType =
            ShellType.values().first { it.javaValue == javaType }
    }
}
