@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin.inputs

import com.pulumi.azurenative.portal.inputs.DashboardPartsPositionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The dashboard's part position.
 * @property colSpan The dashboard's part column span.
 * @property metadata The dashboard part's metadata.
 * @property rowSpan The dashboard's part row span.
 * @property x The dashboard's part x coordinate.
 * @property y The dashboard's part y coordinate.
 */
public data class DashboardPartsPositionArgs(
    public val colSpan: Output<Int>,
    public val metadata: Output<Map<String, Any>>? = null,
    public val rowSpan: Output<Int>,
    public val x: Output<Int>,
    public val y: Output<Int>,
) : ConvertibleToJava<com.pulumi.azurenative.portal.inputs.DashboardPartsPositionArgs> {
    override fun toJava(): com.pulumi.azurenative.portal.inputs.DashboardPartsPositionArgs =
        com.pulumi.azurenative.portal.inputs.DashboardPartsPositionArgs.builder()
            .colSpan(colSpan.applyValue({ args0 -> args0 }))
            .metadata(
                metadata?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .rowSpan(rowSpan.applyValue({ args0 -> args0 }))
            .x(x.applyValue({ args0 -> args0 }))
            .y(y.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DashboardPartsPositionArgs].
 */
@PulumiTagMarker
public class DashboardPartsPositionArgsBuilder internal constructor() {
    private var colSpan: Output<Int>? = null

    private var metadata: Output<Map<String, Any>>? = null

    private var rowSpan: Output<Int>? = null

    private var x: Output<Int>? = null

    private var y: Output<Int>? = null

    /**
     * @param value The dashboard's part column span.
     */
    @JvmName("ksgfvneunfkliqvn")
    public suspend fun colSpan(`value`: Output<Int>) {
        this.colSpan = value
    }

    /**
     * @param value The dashboard part's metadata.
     */
    @JvmName("oqnfhiwckquaxeyf")
    public suspend fun metadata(`value`: Output<Map<String, Any>>) {
        this.metadata = value
    }

    /**
     * @param value The dashboard's part row span.
     */
    @JvmName("utbourbsjtifbhge")
    public suspend fun rowSpan(`value`: Output<Int>) {
        this.rowSpan = value
    }

    /**
     * @param value The dashboard's part x coordinate.
     */
    @JvmName("gdtjsvdcefywabii")
    public suspend fun x(`value`: Output<Int>) {
        this.x = value
    }

    /**
     * @param value The dashboard's part y coordinate.
     */
    @JvmName("setwawxjbtoxjrpw")
    public suspend fun y(`value`: Output<Int>) {
        this.y = value
    }

    /**
     * @param value The dashboard's part column span.
     */
    @JvmName("tcsqsuwqslelcdhf")
    public suspend fun colSpan(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.colSpan = mapped
    }

    /**
     * @param value The dashboard part's metadata.
     */
    @JvmName("jnttjgybgejnbypl")
    public suspend fun metadata(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param values The dashboard part's metadata.
     */
    @JvmName("dyjrcxoxtdrknbht")
    public fun metadata(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value The dashboard's part row span.
     */
    @JvmName("yypwijsgokyvnvnx")
    public suspend fun rowSpan(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rowSpan = mapped
    }

    /**
     * @param value The dashboard's part x coordinate.
     */
    @JvmName("cwliryayidbqyscc")
    public suspend fun x(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.x = mapped
    }

    /**
     * @param value The dashboard's part y coordinate.
     */
    @JvmName("iawoseginrssinvj")
    public suspend fun y(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.y = mapped
    }

    internal fun build(): DashboardPartsPositionArgs = DashboardPartsPositionArgs(
        colSpan = colSpan ?: throw PulumiNullFieldException("colSpan"),
        metadata = metadata,
        rowSpan = rowSpan ?: throw PulumiNullFieldException("rowSpan"),
        x = x ?: throw PulumiNullFieldException("x"),
        y = y ?: throw PulumiNullFieldException("y"),
    )
}
