@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin.inputs

import com.pulumi.azurenative.portal.inputs.GetUserSettingsWithLocationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property location The provider location
 * @property userSettingsName The name of the user settings
 */
public data class GetUserSettingsWithLocationPlainArgs(
    public val location: String,
    public val userSettingsName: String,
) : ConvertibleToJava<com.pulumi.azurenative.portal.inputs.GetUserSettingsWithLocationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.portal.inputs.GetUserSettingsWithLocationPlainArgs =
        com.pulumi.azurenative.portal.inputs.GetUserSettingsWithLocationPlainArgs.builder()
            .location(location.let({ args0 -> args0 }))
            .userSettingsName(userSettingsName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetUserSettingsWithLocationPlainArgs].
 */
@PulumiTagMarker
public class GetUserSettingsWithLocationPlainArgsBuilder internal constructor() {
    private var location: String? = null

    private var userSettingsName: String? = null

    /**
     * @param value The provider location
     */
    @JvmName("orkllriqqnkgwfoi")
    public suspend fun location(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.location = mapped
    }

    /**
     * @param value The name of the user settings
     */
    @JvmName("idhmrxijnxswtlnq")
    public suspend fun userSettingsName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.userSettingsName = mapped
    }

    internal fun build(): GetUserSettingsWithLocationPlainArgs = GetUserSettingsWithLocationPlainArgs(
        location = location ?: throw PulumiNullFieldException("location"),
        userSettingsName = userSettingsName ?: throw PulumiNullFieldException("userSettingsName"),
    )
}
