@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin.inputs

import com.pulumi.azurenative.portal.inputs.UserPropertiesArgs.builder
import com.pulumi.azurenative.portal.kotlin.enums.OsType
import com.pulumi.azurenative.portal.kotlin.enums.ShellType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The cloud shell user settings properties.
 * @property preferredLocation The preferred location of the cloud shell.
 * @property preferredOsType The operating system type of the cloud shell. Deprecated, use preferredShellType.
 * @property preferredShellType The shell type of the cloud shell.
 * @property storageProfile The storage profile of the user settings.
 * @property terminalSettings Settings for terminal appearance.
 */
public data class UserPropertiesArgs(
    public val preferredLocation: Output<String>,
    public val preferredOsType: Output<Either<String, OsType>>,
    public val preferredShellType: Output<Either<String, ShellType>>,
    public val storageProfile: Output<StorageProfileArgs>,
    public val terminalSettings: Output<TerminalSettingsArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.portal.inputs.UserPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.portal.inputs.UserPropertiesArgs =
        com.pulumi.azurenative.portal.inputs.UserPropertiesArgs.builder()
            .preferredLocation(preferredLocation.applyValue({ args0 -> args0 }))
            .preferredOsType(
                preferredOsType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .preferredShellType(
                preferredShellType.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .storageProfile(storageProfile.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .terminalSettings(
                terminalSettings.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [UserPropertiesArgs].
 */
@PulumiTagMarker
public class UserPropertiesArgsBuilder internal constructor() {
    private var preferredLocation: Output<String>? = null

    private var preferredOsType: Output<Either<String, OsType>>? = null

    private var preferredShellType: Output<Either<String, ShellType>>? = null

    private var storageProfile: Output<StorageProfileArgs>? = null

    private var terminalSettings: Output<TerminalSettingsArgs>? = null

    /**
     * @param value The preferred location of the cloud shell.
     */
    @JvmName("tyauahyqaybhndjg")
    public suspend fun preferredLocation(`value`: Output<String>) {
        this.preferredLocation = value
    }

    /**
     * @param value The operating system type of the cloud shell. Deprecated, use preferredShellType.
     */
    @JvmName("rkmsikjdprcyolqk")
    public suspend fun preferredOsType(`value`: Output<Either<String, OsType>>) {
        this.preferredOsType = value
    }

    /**
     * @param value The shell type of the cloud shell.
     */
    @JvmName("vjvweryjobnrvbqn")
    public suspend fun preferredShellType(`value`: Output<Either<String, ShellType>>) {
        this.preferredShellType = value
    }

    /**
     * @param value The storage profile of the user settings.
     */
    @JvmName("uprmextgfvwpmyeb")
    public suspend fun storageProfile(`value`: Output<StorageProfileArgs>) {
        this.storageProfile = value
    }

    /**
     * @param value Settings for terminal appearance.
     */
    @JvmName("kvxandyerryqwpkl")
    public suspend fun terminalSettings(`value`: Output<TerminalSettingsArgs>) {
        this.terminalSettings = value
    }

    /**
     * @param value The preferred location of the cloud shell.
     */
    @JvmName("kearobowdwmfbdal")
    public suspend fun preferredLocation(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preferredLocation = mapped
    }

    /**
     * @param value The operating system type of the cloud shell. Deprecated, use preferredShellType.
     */
    @JvmName("sdnjuxsrjganugrr")
    public suspend fun preferredOsType(`value`: Either<String, OsType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preferredOsType = mapped
    }

    /**
     * @param value The operating system type of the cloud shell. Deprecated, use preferredShellType.
     */
    @JvmName("ynukgfjfkorqxwqq")
    public fun preferredOsType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OsType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preferredOsType = mapped
    }

    /**
     * @param value The operating system type of the cloud shell. Deprecated, use preferredShellType.
     */
    @JvmName("ikolyipoddpbmeru")
    public fun preferredOsType(`value`: OsType) {
        val toBeMapped = Either.ofRight<String, OsType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preferredOsType = mapped
    }

    /**
     * @param value The shell type of the cloud shell.
     */
    @JvmName("fwxahpybapylthhf")
    public suspend fun preferredShellType(`value`: Either<String, ShellType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preferredShellType = mapped
    }

    /**
     * @param value The shell type of the cloud shell.
     */
    @JvmName("yhocpnchdlwkhkdo")
    public fun preferredShellType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ShellType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preferredShellType = mapped
    }

    /**
     * @param value The shell type of the cloud shell.
     */
    @JvmName("efgiolusfosbomej")
    public fun preferredShellType(`value`: ShellType) {
        val toBeMapped = Either.ofRight<String, ShellType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preferredShellType = mapped
    }

    /**
     * @param value The storage profile of the user settings.
     */
    @JvmName("dkapvagguwbyoqgi")
    public suspend fun storageProfile(`value`: StorageProfileArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageProfile = mapped
    }

    /**
     * @param argument The storage profile of the user settings.
     */
    @JvmName("krlllylwdludoalp")
    public suspend fun storageProfile(argument: suspend StorageProfileArgsBuilder.() -> Unit) {
        val toBeMapped = StorageProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageProfile = mapped
    }

    /**
     * @param value Settings for terminal appearance.
     */
    @JvmName("kvgxjxhowwysrjfa")
    public suspend fun terminalSettings(`value`: TerminalSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.terminalSettings = mapped
    }

    /**
     * @param argument Settings for terminal appearance.
     */
    @JvmName("uafokkthmsjlevjn")
    public suspend fun terminalSettings(argument: suspend TerminalSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = TerminalSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.terminalSettings = mapped
    }

    internal fun build(): UserPropertiesArgs = UserPropertiesArgs(
        preferredLocation = preferredLocation ?: throw PulumiNullFieldException("preferredLocation"),
        preferredOsType = preferredOsType ?: throw PulumiNullFieldException("preferredOsType"),
        preferredShellType = preferredShellType ?: throw PulumiNullFieldException("preferredShellType"),
        storageProfile = storageProfile ?: throw PulumiNullFieldException("storageProfile"),
        terminalSettings = terminalSettings ?: throw PulumiNullFieldException("terminalSettings"),
    )
}
