@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Cloud shell console properties.
 * @property osType The operating system type of the cloud shell.
 * @property provisioningState Provisioning state of the console.
 * @property uri Uri of the console.
 */
public data class ConsolePropertiesResponse(
    public val osType: String,
    public val provisioningState: String,
    public val uri: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.portal.outputs.ConsolePropertiesResponse): ConsolePropertiesResponse = ConsolePropertiesResponse(
            osType = javaType.osType(),
            provisioningState = javaType.provisioningState(),
            uri = javaType.uri(),
        )
    }
}
