@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin.outputs

import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A dashboard lens.
 * @property metadata The dashboard len's metadata.
 * @property order The lens order.
 * @property parts The dashboard parts.
 */
public data class DashboardLensResponse(
    public val metadata: Map<String, Any>? = null,
    public val order: Int,
    public val parts: List<DashboardPartsResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.portal.outputs.DashboardLensResponse): DashboardLensResponse = DashboardLensResponse(
            metadata = javaType.metadata().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            order = javaType.order(),
            parts = javaType.parts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.portal.kotlin.outputs.DashboardPartsResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
