@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin.outputs

import kotlin.Suppress

/**
 * A dashboard part.
 * @property metadata The dashboard part's metadata.
 * @property position The dashboard's part position.
 */
public data class DashboardPartsResponse(
    public val metadata: MarkdownPartMetadataResponse? = null,
    public val position: DashboardPartsResponsePosition,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.portal.outputs.DashboardPartsResponse): DashboardPartsResponse = DashboardPartsResponse(
            metadata = javaType.metadata().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.portal.kotlin.outputs.MarkdownPartMetadataResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            position = javaType.position().let({ args0 ->
                com.pulumi.azurenative.portal.kotlin.outputs.DashboardPartsResponsePosition.Companion.toKotlin(args0)
            }),
        )
    }
}
