@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin.outputs

import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The dashboard's part position.
 * @property colSpan The dashboard's part column span.
 * @property metadata The dashboard part's metadata.
 * @property rowSpan The dashboard's part row span.
 * @property x The dashboard's part x coordinate.
 * @property y The dashboard's part y coordinate.
 */
public data class DashboardPartsResponsePosition(
    public val colSpan: Int,
    public val metadata: Map<String, Any>? = null,
    public val rowSpan: Int,
    public val x: Int,
    public val y: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.portal.outputs.DashboardPartsResponsePosition): DashboardPartsResponsePosition = DashboardPartsResponsePosition(
            colSpan = javaType.colSpan(),
            metadata = javaType.metadata().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            rowSpan = javaType.rowSpan(),
            x = javaType.x(),
            y = javaType.y(),
        )
    }
}
