@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The shared dashboard resource definition.
 * @property id Resource Id
 * @property lenses The dashboard lenses.
 * @property location Resource location
 * @property metadata The dashboard metadata.
 * @property name Resource name
 * @property tags Resource tags
 * @property type Resource type
 */
public data class GetDashboardResult(
    public val id: String,
    public val lenses: List<DashboardLensResponse>? = null,
    public val location: String,
    public val metadata: Map<String, Any>? = null,
    public val name: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.portal.outputs.GetDashboardResult): GetDashboardResult = GetDashboardResult(
            id = javaType.id(),
            lenses = javaType.lenses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.portal.kotlin.outputs.DashboardLensResponse.Companion.toKotlin(args0)
                })
            }),
            location = javaType.location(),
            metadata = javaType.metadata().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            name = javaType.name(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
