@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Markdown part metadata.
 * @property inputs Input to dashboard part.
 * @property settings Markdown part settings.
 * @property type The type of dashboard part.
 * Expected value is 'Extension/HubsExtension/PartType/MarkdownPart'.
 */
public data class MarkdownPartMetadataResponse(
    public val inputs: List<Any>? = null,
    public val settings: MarkdownPartMetadataResponseSettings? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.portal.outputs.MarkdownPartMetadataResponse): MarkdownPartMetadataResponse = MarkdownPartMetadataResponse(
            inputs = javaType.inputs().map({ args0 -> args0 }),
            settings = javaType.settings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.portal.kotlin.outputs.MarkdownPartMetadataResponseSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
