@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The setting of the content of markdown part.
 * @property content The content of the markdown part.
 * @property markdownSource The source of the content of the markdown part.
 * @property markdownUri The uri of markdown content.
 * @property subtitle The subtitle of the markdown part.
 * @property title The title of the markdown part.
 */
public data class MarkdownPartMetadataResponseSettingsSettings(
    public val content: String? = null,
    public val markdownSource: Int? = null,
    public val markdownUri: String? = null,
    public val subtitle: String? = null,
    public val title: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.portal.outputs.MarkdownPartMetadataResponseSettingsSettings): MarkdownPartMetadataResponseSettingsSettings = MarkdownPartMetadataResponseSettingsSettings(
            content = javaType.content().map({ args0 -> args0 }).orElse(null),
            markdownSource = javaType.markdownSource().map({ args0 -> args0 }).orElse(null),
            markdownUri = javaType.markdownUri().map({ args0 -> args0 }).orElse(null),
            subtitle = javaType.subtitle().map({ args0 -> args0 }).orElse(null),
            title = javaType.title().map({ args0 -> args0 }).orElse(null),
        )
    }
}
