@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The cloud shell user settings properties.
 * @property preferredLocation The preferred location of the cloud shell.
 * @property preferredOsType The operating system type of the cloud shell. Deprecated, use preferredShellType.
 * @property preferredShellType The shell type of the cloud shell.
 * @property storageProfile The storage profile of the user settings.
 * @property terminalSettings Settings for terminal appearance.
 */
public data class UserPropertiesResponse(
    public val preferredLocation: String,
    public val preferredOsType: String,
    public val preferredShellType: String,
    public val storageProfile: StorageProfileResponse,
    public val terminalSettings: TerminalSettingsResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.portal.outputs.UserPropertiesResponse): UserPropertiesResponse = UserPropertiesResponse(
            preferredLocation = javaType.preferredLocation(),
            preferredOsType = javaType.preferredOsType(),
            preferredShellType = javaType.preferredShellType(),
            storageProfile = javaType.storageProfile().let({ args0 ->
                com.pulumi.azurenative.portal.kotlin.outputs.StorageProfileResponse.Companion.toKotlin(args0)
            }),
            terminalSettings = javaType.terminalSettings().let({ args0 ->
                com.pulumi.azurenative.portal.kotlin.outputs.TerminalSettingsResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
