@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Violation information.
 * @property errorMessage Error message.
 * @property id Id of the item that violates tenant configuration.
 * @property userId Id of the user who owns violated item.
 */
public data class ViolationResponse(
    public val errorMessage: String,
    public val id: String,
    public val userId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.portal.outputs.ViolationResponse): ViolationResponse = ViolationResponse(
            errorMessage = javaType.errorMessage(),
            id = javaType.id(),
            userId = javaType.userId(),
        )
    }
}
