@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portalservices.kotlin

import com.pulumi.azurenative.portalservices.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.portalservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [CopilotSetting].
 */
@PulumiTagMarker
public class CopilotSettingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CopilotSettingArgs = CopilotSettingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CopilotSettingArgsBuilder.() -> Unit) {
        val builder = CopilotSettingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CopilotSetting {
        val builtJavaResource =
            com.pulumi.azurenative.portalservices.CopilotSetting(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CopilotSetting(builtJavaResource)
    }
}

/**
 * The copilot settings tenant resource definition.
 * Azure REST API version: 2024-04-01-preview.
 * ## Example Usage
 * ### Create a new Copilot settings or update an existing one
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var copilotSetting = new AzureNative.PortalServices.CopilotSetting("copilotSetting", new()
 *     {
 *         AccessControlEnabled = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/portalservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := portalservices.NewCopilotSetting(ctx, "copilotSetting", &portalservices.CopilotSettingArgs{
 * 			AccessControlEnabled: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.portalservices.CopilotSetting;
 * import com.pulumi.azurenative.portalservices.CopilotSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var copilotSetting = new CopilotSetting("copilotSetting", CopilotSettingArgs.builder()
 *             .accessControlEnabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:portalservices:CopilotSetting default /providers/Microsoft.PortalServices/copilotSettings/default
 * ```
 */
public class CopilotSetting internal constructor(
    override val javaResource: com.pulumi.azurenative.portalservices.CopilotSetting,
) : KotlinCustomResource(javaResource, CopilotSettingMapper) {
    /**
     * Boolean indicating if role-based access control is enabled for copilot in this tenant.
     */
    public val accessControlEnabled: Output<Boolean>
        get() = javaResource.accessControlEnabled().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the last provisioning operation performed on the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CopilotSettingMapper : ResourceMapper<CopilotSetting> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.portalservices.CopilotSetting::class == javaResource::class

    override fun map(javaResource: Resource): CopilotSetting = CopilotSetting(
        javaResource as
            com.pulumi.azurenative.portalservices.CopilotSetting,
    )
}

/**
 * @see [CopilotSetting].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CopilotSetting].
 */
public suspend fun copilotSetting(
    name: String,
    block: suspend CopilotSettingResourceBuilder.() -> Unit,
): CopilotSetting {
    val builder = CopilotSettingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CopilotSetting].
 * @param name The _unique_ name of the resulting resource.
 */
public fun copilotSetting(name: String): CopilotSetting {
    val builder = CopilotSettingResourceBuilder()
    builder.name(name)
    return builder.build()
}
