@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portalservices.kotlin

import com.pulumi.azurenative.portalservices.CopilotSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The copilot settings tenant resource definition.
 * Azure REST API version: 2024-04-01-preview.
 * ## Example Usage
 * ### Create a new Copilot settings or update an existing one
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var copilotSetting = new AzureNative.PortalServices.CopilotSetting("copilotSetting", new()
 *     {
 *         AccessControlEnabled = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/portalservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := portalservices.NewCopilotSetting(ctx, "copilotSetting", &portalservices.CopilotSettingArgs{
 * 			AccessControlEnabled: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.portalservices.CopilotSetting;
 * import com.pulumi.azurenative.portalservices.CopilotSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var copilotSetting = new CopilotSetting("copilotSetting", CopilotSettingArgs.builder()
 *             .accessControlEnabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:portalservices:CopilotSetting default /providers/Microsoft.PortalServices/copilotSettings/default
 * ```
 * @property accessControlEnabled Boolean indicating if role-based access control is enabled for copilot in this tenant.
 */
public data class CopilotSettingArgs(
    public val accessControlEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.portalservices.CopilotSettingArgs> {
    override fun toJava(): com.pulumi.azurenative.portalservices.CopilotSettingArgs =
        com.pulumi.azurenative.portalservices.CopilotSettingArgs.builder()
            .accessControlEnabled(accessControlEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CopilotSettingArgs].
 */
@PulumiTagMarker
public class CopilotSettingArgsBuilder internal constructor() {
    private var accessControlEnabled: Output<Boolean>? = null

    /**
     * @param value Boolean indicating if role-based access control is enabled for copilot in this tenant.
     */
    @JvmName("oajtpswcgjvvlwix")
    public suspend fun accessControlEnabled(`value`: Output<Boolean>) {
        this.accessControlEnabled = value
    }

    /**
     * @param value Boolean indicating if role-based access control is enabled for copilot in this tenant.
     */
    @JvmName("mdiumryqitbihlqf")
    public suspend fun accessControlEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessControlEnabled = mapped
    }

    internal fun build(): CopilotSettingArgs = CopilotSettingArgs(
        accessControlEnabled = accessControlEnabled,
    )
}
