@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portalservices.kotlin

import com.pulumi.azurenative.portalservices.PortalservicesFunctions.getCopilotSettingPlain
import com.pulumi.azurenative.portalservices.kotlin.outputs.GetCopilotSettingResult
import com.pulumi.azurenative.portalservices.kotlin.outputs.GetCopilotSettingResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.Suppress

public object PortalservicesFunctions {
    /**
     * Get a CopilotSettingsResource
     * Azure REST API version: 2024-04-01-preview.
     * @param argument null
     * @return The copilot settings tenant resource definition.
     */
    public suspend fun getCopilotSetting(): GetCopilotSettingResult =
        toKotlin(getCopilotSettingPlain().await())
}
