@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerbi.kotlin.inputs

import com.pulumi.azurenative.powerbi.inputs.GetPrivateEndpointConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property azureResourceName The name of the Azure resource.
 * @property privateEndpointName The name of the private endpoint.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetPrivateEndpointConnectionPlainArgs(
    public val azureResourceName: String,
    public val privateEndpointName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.powerbi.inputs.GetPrivateEndpointConnectionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.powerbi.inputs.GetPrivateEndpointConnectionPlainArgs = com.pulumi.azurenative.powerbi.inputs.GetPrivateEndpointConnectionPlainArgs.builder()
        .azureResourceName(azureResourceName.let({ args0 -> args0 }))
        .privateEndpointName(privateEndpointName.let({ args0 -> args0 }))
        .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateEndpointConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetPrivateEndpointConnectionPlainArgsBuilder internal constructor() {
    private var azureResourceName: String? = null

    private var privateEndpointName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Azure resource.
     */
    @JvmName("yrmghpykunfrglxv")
    public suspend fun azureResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.azureResourceName = mapped
    }

    /**
     * @param value The name of the private endpoint.
     */
    @JvmName("swhislhbeqsopkyx")
    public suspend fun privateEndpointName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateEndpointName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("mqdtwkxrjefaryit")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPrivateEndpointConnectionPlainArgs =
        GetPrivateEndpointConnectionPlainArgs(
            azureResourceName = azureResourceName ?: throw PulumiNullFieldException("azureResourceName"),
            privateEndpointName = privateEndpointName ?: throw PulumiNullFieldException("privateEndpointName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
