@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerbi.kotlin.inputs

import com.pulumi.azurenative.powerbi.inputs.GetWorkspaceCollectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName Azure resource group
 * @property workspaceCollectionName Power BI Embedded Workspace Collection name
 */
public data class GetWorkspaceCollectionPlainArgs(
    public val resourceGroupName: String,
    public val workspaceCollectionName: String,
) : ConvertibleToJava<com.pulumi.azurenative.powerbi.inputs.GetWorkspaceCollectionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.powerbi.inputs.GetWorkspaceCollectionPlainArgs =
        com.pulumi.azurenative.powerbi.inputs.GetWorkspaceCollectionPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceCollectionName(workspaceCollectionName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWorkspaceCollectionPlainArgs].
 */
@PulumiTagMarker
public class GetWorkspaceCollectionPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var workspaceCollectionName: String? = null

    /**
     * @param value Azure resource group
     */
    @JvmName("uvjtgpqcfnfnbrkg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Power BI Embedded Workspace Collection name
     */
    @JvmName("yigfhqcrtybgvjly")
    public suspend fun workspaceCollectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceCollectionName = mapped
    }

    internal fun build(): GetWorkspaceCollectionPlainArgs = GetWorkspaceCollectionPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceCollectionName = workspaceCollectionName ?: throw
            PulumiNullFieldException("workspaceCollectionName"),
    )
}
