@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerbi.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property id Resource id
 * @property location Azure location
 * @property name Workspace collection name
 * @property properties Properties
 * @property sku
 * @property tags
 * @property type Resource type
 */
public data class GetWorkspaceCollectionResult(
    public val id: String? = null,
    public val location: String? = null,
    public val name: String? = null,
    public val properties: Any,
    public val sku: AzureSkuResponse? = null,
    public val tags: Map<String, String>? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.powerbi.outputs.GetWorkspaceCollectionResult): GetWorkspaceCollectionResult = GetWorkspaceCollectionResult(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            properties = javaType.properties(),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.powerbi.kotlin.outputs.AzureSkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
