@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerplatform.kotlin

import com.pulumi.azurenative.powerplatform.PowerplatformFunctions.getAccountPlain
import com.pulumi.azurenative.powerplatform.PowerplatformFunctions.getEnterprisePolicyPlain
import com.pulumi.azurenative.powerplatform.PowerplatformFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.powerplatform.kotlin.inputs.GetAccountPlainArgs
import com.pulumi.azurenative.powerplatform.kotlin.inputs.GetAccountPlainArgsBuilder
import com.pulumi.azurenative.powerplatform.kotlin.inputs.GetEnterprisePolicyPlainArgs
import com.pulumi.azurenative.powerplatform.kotlin.inputs.GetEnterprisePolicyPlainArgsBuilder
import com.pulumi.azurenative.powerplatform.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.powerplatform.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.powerplatform.kotlin.outputs.GetAccountResult
import com.pulumi.azurenative.powerplatform.kotlin.outputs.GetEnterprisePolicyResult
import com.pulumi.azurenative.powerplatform.kotlin.outputs.GetPrivateEndpointConnectionResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.powerplatform.kotlin.outputs.GetAccountResult.Companion.toKotlin as getAccountResultToKotlin
import com.pulumi.azurenative.powerplatform.kotlin.outputs.GetEnterprisePolicyResult.Companion.toKotlin as getEnterprisePolicyResultToKotlin
import com.pulumi.azurenative.powerplatform.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin

public object PowerplatformFunctions {
    /**
     * Get information about an account.
     * Azure REST API version: 2020-10-30-preview.
     * @param argument null
     * @return Definition of the account.
     */
    public suspend fun getAccount(argument: GetAccountPlainArgs): GetAccountResult =
        getAccountResultToKotlin(getAccountPlain(argument.toJava()).await())

    /**
     * @see [getAccount].
     * @param accountName Name of the account.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Definition of the account.
     */
    public suspend fun getAccount(accountName: String, resourceGroupName: String): GetAccountResult {
        val argument = GetAccountPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
        )
        return getAccountResultToKotlin(getAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccount].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;powerplatform&#46;kotlin&#46;inputs&#46;GetAccountPlainArgs].
     * @return Definition of the account.
     */
    public suspend fun getAccount(argument: suspend GetAccountPlainArgsBuilder.() -> Unit): GetAccountResult {
        val builder = GetAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccountResultToKotlin(getAccountPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information about an EnterprisePolicy
     * Azure REST API version: 2020-10-30-preview.
     * @param argument null
     * @return Definition of the EnterprisePolicy.
     */
    public suspend fun getEnterprisePolicy(argument: GetEnterprisePolicyPlainArgs): GetEnterprisePolicyResult =
        getEnterprisePolicyResultToKotlin(getEnterprisePolicyPlain(argument.toJava()).await())

    /**
     * @see [getEnterprisePolicy].
     * @param enterprisePolicyName The EnterprisePolicy name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Definition of the EnterprisePolicy.
     */
    public suspend fun getEnterprisePolicy(enterprisePolicyName: String, resourceGroupName: String): GetEnterprisePolicyResult {
        val argument = GetEnterprisePolicyPlainArgs(
            enterprisePolicyName = enterprisePolicyName,
            resourceGroupName = resourceGroupName,
        )
        return getEnterprisePolicyResultToKotlin(getEnterprisePolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getEnterprisePolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;powerplatform&#46;kotlin&#46;inputs&#46;GetEnterprisePolicyPlainArgs].
     * @return Definition of the EnterprisePolicy.
     */
    public suspend fun getEnterprisePolicy(argument: suspend GetEnterprisePolicyPlainArgsBuilder.() -> Unit): GetEnterprisePolicyResult {
        val builder = GetEnterprisePolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEnterprisePolicyResultToKotlin(getEnterprisePolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a private endpoint connection.
     * Azure REST API version: 2020-10-30-preview.
     * @param argument null
     * @return A private endpoint connection
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs): GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param enterprisePolicyName EnterprisePolicy for the Microsoft Azure subscription.
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return A private endpoint connection
     */
    public suspend fun getPrivateEndpointConnection(
        enterprisePolicyName: String,
        privateEndpointConnectionName: String,
        resourceGroupName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            enterprisePolicyName = enterprisePolicyName,
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;powerplatform&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return A private endpoint connection
     */
    public suspend fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit): GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }
}
