@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerplatform.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The health status of the resource.
 */
public enum class HealthStatus(
    public val javaValue: com.pulumi.azurenative.powerplatform.enums.HealthStatus,
) : ConvertibleToJava<com.pulumi.azurenative.powerplatform.enums.HealthStatus> {
    Undetermined(com.pulumi.azurenative.powerplatform.enums.HealthStatus.Undetermined),
    Healthy(com.pulumi.azurenative.powerplatform.enums.HealthStatus.Healthy),
    Warning(com.pulumi.azurenative.powerplatform.enums.HealthStatus.Warning),
    Unhealthy(com.pulumi.azurenative.powerplatform.enums.HealthStatus.Unhealthy),
    ;

    override fun toJava(): com.pulumi.azurenative.powerplatform.enums.HealthStatus = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.powerplatform.enums.HealthStatus): HealthStatus = HealthStatus.values().first { it.javaValue == javaType }
    }
}
