@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerplatform.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of identity used for the EnterprisePolicy. Currently, the only supported type is 'SystemAssigned', which implicitly creates an identity.
 */
public enum class ResourceIdentityType(
    public val javaValue: com.pulumi.azurenative.powerplatform.enums.ResourceIdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.powerplatform.enums.ResourceIdentityType> {
    SystemAssigned(com.pulumi.azurenative.powerplatform.enums.ResourceIdentityType.SystemAssigned),
    None(com.pulumi.azurenative.powerplatform.enums.ResourceIdentityType.None),
    ;

    override fun toJava(): com.pulumi.azurenative.powerplatform.enums.ResourceIdentityType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.powerplatform.enums.ResourceIdentityType): ResourceIdentityType = ResourceIdentityType.values().first { it.javaValue == javaType }
    }
}
