@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerplatform.kotlin.inputs

import com.pulumi.azurenative.powerplatform.inputs.PropertiesNetworkInjectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Settings concerning network injection.
 * @property virtualNetworks Network injection configuration
 */
public data class PropertiesNetworkInjectionArgs(
    public val virtualNetworks: Output<VirtualNetworkPropertiesListArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.powerplatform.inputs.PropertiesNetworkInjectionArgs> {
    override fun toJava(): com.pulumi.azurenative.powerplatform.inputs.PropertiesNetworkInjectionArgs = com.pulumi.azurenative.powerplatform.inputs.PropertiesNetworkInjectionArgs.builder()
        .virtualNetworks(
            virtualNetworks?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        ).build()
}

/**
 * Builder for [PropertiesNetworkInjectionArgs].
 */
@PulumiTagMarker
public class PropertiesNetworkInjectionArgsBuilder internal constructor() {
    private var virtualNetworks: Output<VirtualNetworkPropertiesListArgs>? = null

    /**
     * @param value Network injection configuration
     */
    @JvmName("hsfxolvtfkwwxxua")
    public suspend fun virtualNetworks(`value`: Output<VirtualNetworkPropertiesListArgs>) {
        this.virtualNetworks = value
    }

    /**
     * @param value Network injection configuration
     */
    @JvmName("kucskgexduxvkqma")
    public suspend fun virtualNetworks(`value`: VirtualNetworkPropertiesListArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworks = mapped
    }

    /**
     * @param argument Network injection configuration
     */
    @JvmName("sdyjsnsviuyyjhep")
    public suspend fun virtualNetworks(argument: suspend VirtualNetworkPropertiesListArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNetworkPropertiesListArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualNetworks = mapped
    }

    internal fun build(): PropertiesNetworkInjectionArgs = PropertiesNetworkInjectionArgs(
        virtualNetworks = virtualNetworks,
    )
}
