@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerplatform.kotlin.inputs

import com.pulumi.azurenative.powerplatform.inputs.VirtualNetworkPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Settings concerning the virtual network.
 * @property id Uri of the virtual network.
 * @property subnet Properties of a subnet.
 */
public data class VirtualNetworkPropertiesArgs(
    public val id: Output<String>? = null,
    public val subnet: Output<SubnetPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.powerplatform.inputs.VirtualNetworkPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.powerplatform.inputs.VirtualNetworkPropertiesArgs =
        com.pulumi.azurenative.powerplatform.inputs.VirtualNetworkPropertiesArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .subnet(subnet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualNetworkPropertiesArgs].
 */
@PulumiTagMarker
public class VirtualNetworkPropertiesArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var subnet: Output<SubnetPropertiesArgs>? = null

    /**
     * @param value Uri of the virtual network.
     */
    @JvmName("vrasqstyqqrwqlfx")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Properties of a subnet.
     */
    @JvmName("ijsyqmugessfdusr")
    public suspend fun subnet(`value`: Output<SubnetPropertiesArgs>) {
        this.subnet = value
    }

    /**
     * @param value Uri of the virtual network.
     */
    @JvmName("todufjigwqlponca")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Properties of a subnet.
     */
    @JvmName("lqmyebmxcosoxsjk")
    public suspend fun subnet(`value`: SubnetPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnet = mapped
    }

    /**
     * @param argument Properties of a subnet.
     */
    @JvmName("saeltbqjwyiwflvw")
    public suspend fun subnet(argument: suspend SubnetPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SubnetPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.subnet = mapped
    }

    internal fun build(): VirtualNetworkPropertiesArgs = VirtualNetworkPropertiesArgs(
        id = id,
        subnet = subnet,
    )
}
