@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerplatform.kotlin.inputs

import com.pulumi.azurenative.powerplatform.inputs.VirtualNetworkPropertiesListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A list of private link resources
 * @property nextLink Next page link if any.
 * @property value Array of virtual networks.
 */
public data class VirtualNetworkPropertiesListArgs(
    public val nextLink: Output<String>? = null,
    public val `value`: Output<List<VirtualNetworkPropertiesArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.powerplatform.inputs.VirtualNetworkPropertiesListArgs> {
    override fun toJava(): com.pulumi.azurenative.powerplatform.inputs.VirtualNetworkPropertiesListArgs =
        com.pulumi.azurenative.powerplatform.inputs.VirtualNetworkPropertiesListArgs.builder()
            .nextLink(nextLink?.applyValue({ args0 -> args0 }))
            .`value`(
                `value`?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [VirtualNetworkPropertiesListArgs].
 */
@PulumiTagMarker
public class VirtualNetworkPropertiesListArgsBuilder internal constructor() {
    private var nextLink: Output<String>? = null

    private var `value`: Output<List<VirtualNetworkPropertiesArgs>>? = null

    /**
     * @param value Next page link if any.
     */
    @JvmName("cbgbdajimkenuegt")
    public suspend fun nextLink(`value`: Output<String>) {
        this.nextLink = value
    }

    /**
     * @param value Array of virtual networks.
     */
    @JvmName("fntksdywvoctcpsl")
    public suspend fun `value`(`value`: Output<List<VirtualNetworkPropertiesArgs>>) {
        this.`value` = value
    }

    @JvmName("fhujpmbhbqrbxhwj")
    public suspend fun `value`(vararg values: Output<VirtualNetworkPropertiesArgs>) {
        this.`value` = Output.all(values.asList())
    }

    /**
     * @param values Array of virtual networks.
     */
    @JvmName("mgginapgtatjnsaj")
    public suspend fun `value`(values: List<Output<VirtualNetworkPropertiesArgs>>) {
        this.`value` = Output.all(values)
    }

    /**
     * @param value Next page link if any.
     */
    @JvmName("mmulhbmvbifidhaj")
    public suspend fun nextLink(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nextLink = mapped
    }

    /**
     * @param value Array of virtual networks.
     */
    @JvmName("jnrcindwplgbbcfr")
    public suspend fun `value`(`value`: List<VirtualNetworkPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    /**
     * @param argument Array of virtual networks.
     */
    @JvmName("dnypuqgsrnrgssbe")
    public suspend fun `value`(argument: List<suspend VirtualNetworkPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.`value` = mapped
    }

    /**
     * @param argument Array of virtual networks.
     */
    @JvmName("qjlfvaagwdemtili")
    public suspend fun `value`(vararg argument: suspend VirtualNetworkPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.`value` = mapped
    }

    /**
     * @param argument Array of virtual networks.
     */
    @JvmName("ykggkwxfjbdbxshp")
    public suspend fun `value`(argument: suspend VirtualNetworkPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualNetworkPropertiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.`value` = mapped
    }

    /**
     * @param values Array of virtual networks.
     */
    @JvmName("seqxnkvdcwvjkbtb")
    public suspend fun `value`(vararg values: VirtualNetworkPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): VirtualNetworkPropertiesListArgs = VirtualNetworkPropertiesListArgs(
        nextLink = nextLink,
        `value` = `value`,
    )
}
