@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The identity of the EnterprisePolicy.
 * @property systemAssignedIdentityPrincipalId The principal id of EnterprisePolicy identity.
 * @property tenantId The tenant id associated with the EnterprisePolicy.
 * @property type The type of identity used for the EnterprisePolicy. Currently, the only supported type is 'SystemAssigned', which implicitly creates an identity.
 */
public data class EnterprisePolicyIdentityResponse(
    public val systemAssignedIdentityPrincipalId: String,
    public val tenantId: String,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.powerplatform.outputs.EnterprisePolicyIdentityResponse): EnterprisePolicyIdentityResponse = EnterprisePolicyIdentityResponse(
            systemAssignedIdentityPrincipalId = javaType.systemAssignedIdentityPrincipalId(),
            tenantId = javaType.tenantId(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
