@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Settings concerning key vault encryption for a configuration store.
 * @property id Uri of KeyVault
 * @property key Identity of the secret that includes name and version.
 */
public data class KeyVaultPropertiesResponse(
    public val id: String? = null,
    public val key: KeyPropertiesResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.powerplatform.outputs.KeyVaultPropertiesResponse): KeyVaultPropertiesResponse = KeyVaultPropertiesResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            key = javaType.key().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.powerplatform.kotlin.outputs.KeyPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
