@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The encryption settings for a configuration store.
 * @property keyVault Key vault properties.
 * @property state The state of onboarding, which only appears in the response.
 */
public data class PropertiesResponseEncryption(
    public val keyVault: KeyVaultPropertiesResponse? = null,
    public val state: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.powerplatform.outputs.PropertiesResponseEncryption): PropertiesResponseEncryption = PropertiesResponseEncryption(
            keyVault = javaType.keyVault().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.powerplatform.kotlin.outputs.KeyVaultPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
        )
    }
}
