@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.professionalservice.kotlin

import com.pulumi.azurenative.professionalservice.kotlin.outputs.ProfessionalServiceResourceResponseProperties
import com.pulumi.azurenative.professionalservice.kotlin.outputs.ProfessionalServiceResourceResponseProperties.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ProfessionalServiceSubscriptionLevel].
 */
@PulumiTagMarker
public class ProfessionalServiceSubscriptionLevelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProfessionalServiceSubscriptionLevelArgs =
        ProfessionalServiceSubscriptionLevelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProfessionalServiceSubscriptionLevelArgsBuilder.() -> Unit) {
        val builder = ProfessionalServiceSubscriptionLevelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProfessionalServiceSubscriptionLevel {
        val builtJavaResource =
            com.pulumi.azurenative.professionalservice.ProfessionalServiceSubscriptionLevel(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ProfessionalServiceSubscriptionLevel(builtJavaResource)
    }
}

/**
 * ProfessionalService REST API resource definition.
 * Azure REST API version: 2023-07-01-preview. Prior API version in Azure Native 1.x: 2023-07-01-preview.
 * ## Example Usage
 * ### Create subscription level ProfessionalService resource (indefinite term)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var professionalServiceSubscriptionLevel = new AzureNative.ProfessionalService.ProfessionalServiceSubscriptionLevel("professionalServiceSubscriptionLevel", new()
 *     {
 *         Location = "global",
 *         Name = "MyContosoPS",
 *         Properties = new AzureNative.ProfessionalService.Inputs.ProfessionalServiceCreationPropertiesArgs
 *         {
 *             OfferId = "testprofservice",
 *             PublisherId = "microsoft-contoso",
 *             QuoteId = "quoteabc",
 *             SkuId = "ff051f4f-a6d9-4cbc-8d9a-2a41bd468abc",
 *         },
 *         ResourceGroupName = "my-ps-rg",
 *         ResourceName = "MyContosoPS",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/professionalservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := professionalservice.NewProfessionalServiceSubscriptionLevel(ctx, "professionalServiceSubscriptionLevel", &professionalservice.ProfessionalServiceSubscriptionLevelArgs{
 * 			Location: pulumi.String("global"),
 * 			Name:     pulumi.String("MyContosoPS"),
 * 			Properties: &professionalservice.ProfessionalServiceCreationPropertiesArgs{
 * 				OfferId:     pulumi.String("testprofservice"),
 * 				PublisherId: pulumi.String("microsoft-contoso"),
 * 				QuoteId:     pulumi.String("quoteabc"),
 * 				SkuId:       pulumi.String("ff051f4f-a6d9-4cbc-8d9a-2a41bd468abc"),
 * 			},
 * 			ResourceGroupName: pulumi.String("my-ps-rg"),
 * 			ResourceName:      pulumi.String("MyContosoPS"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.professionalservice.ProfessionalServiceSubscriptionLevel;
 * import com.pulumi.azurenative.professionalservice.ProfessionalServiceSubscriptionLevelArgs;
 * import com.pulumi.azurenative.professionalservice.inputs.ProfessionalServiceCreationPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var professionalServiceSubscriptionLevel = new ProfessionalServiceSubscriptionLevel("professionalServiceSubscriptionLevel", ProfessionalServiceSubscriptionLevelArgs.builder()
 *             .location("global")
 *             .name("MyContosoPS")
 *             .properties(ProfessionalServiceCreationPropertiesArgs.builder()
 *                 .offerId("testprofservice")
 *                 .publisherId("microsoft-contoso")
 *                 .quoteId("quoteabc")
 *                 .skuId("ff051f4f-a6d9-4cbc-8d9a-2a41bd468abc")
 *                 .build())
 *             .resourceGroupName("my-ps-rg")
 *             .resourceName("MyContosoPS")
 *             .build());
 *     }
 * }
 * ```
 * ### Create subscription level ProfessionalService resource (with term)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var professionalServiceSubscriptionLevel = new AzureNative.ProfessionalService.ProfessionalServiceSubscriptionLevel("professionalServiceSubscriptionLevel", new()
 *     {
 *         Location = "global",
 *         Name = "MyContosoPS",
 *         Properties = new AzureNative.ProfessionalService.Inputs.ProfessionalServiceCreationPropertiesArgs
 *         {
 *             BillingPeriod = "P1Y",
 *             OfferId = "testprofservice",
 *             PublisherId = "microsoft-contoso",
 *             QuoteId = "quoteabc",
 *             SkuId = "ff051f4f-a6d9-4cbc-8d9a-2a41bd468abc",
 *             TermUnit = "P3Y",
 *         },
 *         ResourceGroupName = "my-ps-rg",
 *         ResourceName = "MyContosoPS",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/professionalservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := professionalservice.NewProfessionalServiceSubscriptionLevel(ctx, "professionalServiceSubscriptionLevel", &professionalservice.ProfessionalServiceSubscriptionLevelArgs{
 * 			Location: pulumi.String("global"),
 * 			Name:     pulumi.String("MyContosoPS"),
 * 			Properties: &professionalservice.ProfessionalServiceCreationPropertiesArgs{
 * 				BillingPeriod: pulumi.String("P1Y"),
 * 				OfferId:       pulumi.String("testprofservice"),
 * 				PublisherId:   pulumi.String("microsoft-contoso"),
 * 				QuoteId:       pulumi.String("quoteabc"),
 * 				SkuId:         pulumi.String("ff051f4f-a6d9-4cbc-8d9a-2a41bd468abc"),
 * 				TermUnit:      pulumi.String("P3Y"),
 * 			},
 * 			ResourceGroupName: pulumi.String("my-ps-rg"),
 * 			ResourceName:      pulumi.String("MyContosoPS"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.professionalservice.ProfessionalServiceSubscriptionLevel;
 * import com.pulumi.azurenative.professionalservice.ProfessionalServiceSubscriptionLevelArgs;
 * import com.pulumi.azurenative.professionalservice.inputs.ProfessionalServiceCreationPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var professionalServiceSubscriptionLevel = new ProfessionalServiceSubscriptionLevel("professionalServiceSubscriptionLevel", ProfessionalServiceSubscriptionLevelArgs.builder()
 *             .location("global")
 *             .name("MyContosoPS")
 *             .properties(ProfessionalServiceCreationPropertiesArgs.builder()
 *                 .billingPeriod("P1Y")
 *                 .offerId("testprofservice")
 *                 .publisherId("microsoft-contoso")
 *                 .quoteId("quoteabc")
 *                 .skuId("ff051f4f-a6d9-4cbc-8d9a-2a41bd468abc")
 *                 .termUnit("P3Y")
 *                 .build())
 *             .resourceGroupName("my-ps-rg")
 *             .resourceName("MyContosoPS")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:professionalservice:ProfessionalServiceSubscriptionLevel MyContosoPS /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ProfessionalService/resources/{resourceName}
 * ```
 */
public class ProfessionalServiceSubscriptionLevel internal constructor(
    override val javaResource: com.pulumi.azurenative.professionalservice.ProfessionalServiceSubscriptionLevel,
) : KotlinCustomResource(javaResource, ProfessionalServiceSubscriptionLevelMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * professionalService properties
     */
    public val properties: Output<ProfessionalServiceResourceResponseProperties>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * the resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ProfessionalServiceSubscriptionLevelMapper :
    ResourceMapper<ProfessionalServiceSubscriptionLevel> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.professionalservice.ProfessionalServiceSubscriptionLevel::class == javaResource::class

    override fun map(javaResource: Resource): ProfessionalServiceSubscriptionLevel =
        ProfessionalServiceSubscriptionLevel(
            javaResource as
                com.pulumi.azurenative.professionalservice.ProfessionalServiceSubscriptionLevel,
        )
}

/**
 * @see [ProfessionalServiceSubscriptionLevel].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProfessionalServiceSubscriptionLevel].
 */
public suspend fun professionalServiceSubscriptionLevel(
    name: String,
    block: suspend ProfessionalServiceSubscriptionLevelResourceBuilder.() -> Unit,
): ProfessionalServiceSubscriptionLevel {
    val builder = ProfessionalServiceSubscriptionLevelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProfessionalServiceSubscriptionLevel].
 * @param name The _unique_ name of the resulting resource.
 */
public fun professionalServiceSubscriptionLevel(name: String): ProfessionalServiceSubscriptionLevel {
    val builder = ProfessionalServiceSubscriptionLevelResourceBuilder()
    builder.name(name)
    return builder.build()
}
