@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.professionalservice.kotlin

import com.pulumi.azurenative.professionalservice.ProfessionalServiceSubscriptionLevelArgs.builder
import com.pulumi.azurenative.professionalservice.kotlin.inputs.ProfessionalServiceCreationPropertiesArgs
import com.pulumi.azurenative.professionalservice.kotlin.inputs.ProfessionalServiceCreationPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * ProfessionalService REST API resource definition.
 * Azure REST API version: 2023-07-01-preview. Prior API version in Azure Native 1.x: 2023-07-01-preview.
 * ## Example Usage
 * ### Create subscription level ProfessionalService resource (indefinite term)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var professionalServiceSubscriptionLevel = new AzureNative.ProfessionalService.ProfessionalServiceSubscriptionLevel("professionalServiceSubscriptionLevel", new()
 *     {
 *         Location = "global",
 *         Name = "MyContosoPS",
 *         Properties = new AzureNative.ProfessionalService.Inputs.ProfessionalServiceCreationPropertiesArgs
 *         {
 *             OfferId = "testprofservice",
 *             PublisherId = "microsoft-contoso",
 *             QuoteId = "quoteabc",
 *             SkuId = "ff051f4f-a6d9-4cbc-8d9a-2a41bd468abc",
 *         },
 *         ResourceGroupName = "my-ps-rg",
 *         ResourceName = "MyContosoPS",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/professionalservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := professionalservice.NewProfessionalServiceSubscriptionLevel(ctx, "professionalServiceSubscriptionLevel", &professionalservice.ProfessionalServiceSubscriptionLevelArgs{
 * 			Location: pulumi.String("global"),
 * 			Name:     pulumi.String("MyContosoPS"),
 * 			Properties: &professionalservice.ProfessionalServiceCreationPropertiesArgs{
 * 				OfferId:     pulumi.String("testprofservice"),
 * 				PublisherId: pulumi.String("microsoft-contoso"),
 * 				QuoteId:     pulumi.String("quoteabc"),
 * 				SkuId:       pulumi.String("ff051f4f-a6d9-4cbc-8d9a-2a41bd468abc"),
 * 			},
 * 			ResourceGroupName: pulumi.String("my-ps-rg"),
 * 			ResourceName:      pulumi.String("MyContosoPS"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.professionalservice.ProfessionalServiceSubscriptionLevel;
 * import com.pulumi.azurenative.professionalservice.ProfessionalServiceSubscriptionLevelArgs;
 * import com.pulumi.azurenative.professionalservice.inputs.ProfessionalServiceCreationPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var professionalServiceSubscriptionLevel = new ProfessionalServiceSubscriptionLevel("professionalServiceSubscriptionLevel", ProfessionalServiceSubscriptionLevelArgs.builder()
 *             .location("global")
 *             .name("MyContosoPS")
 *             .properties(ProfessionalServiceCreationPropertiesArgs.builder()
 *                 .offerId("testprofservice")
 *                 .publisherId("microsoft-contoso")
 *                 .quoteId("quoteabc")
 *                 .skuId("ff051f4f-a6d9-4cbc-8d9a-2a41bd468abc")
 *                 .build())
 *             .resourceGroupName("my-ps-rg")
 *             .resourceName("MyContosoPS")
 *             .build());
 *     }
 * }
 * ```
 * ### Create subscription level ProfessionalService resource (with term)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var professionalServiceSubscriptionLevel = new AzureNative.ProfessionalService.ProfessionalServiceSubscriptionLevel("professionalServiceSubscriptionLevel", new()
 *     {
 *         Location = "global",
 *         Name = "MyContosoPS",
 *         Properties = new AzureNative.ProfessionalService.Inputs.ProfessionalServiceCreationPropertiesArgs
 *         {
 *             BillingPeriod = "P1Y",
 *             OfferId = "testprofservice",
 *             PublisherId = "microsoft-contoso",
 *             QuoteId = "quoteabc",
 *             SkuId = "ff051f4f-a6d9-4cbc-8d9a-2a41bd468abc",
 *             TermUnit = "P3Y",
 *         },
 *         ResourceGroupName = "my-ps-rg",
 *         ResourceName = "MyContosoPS",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/professionalservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := professionalservice.NewProfessionalServiceSubscriptionLevel(ctx, "professionalServiceSubscriptionLevel", &professionalservice.ProfessionalServiceSubscriptionLevelArgs{
 * 			Location: pulumi.String("global"),
 * 			Name:     pulumi.String("MyContosoPS"),
 * 			Properties: &professionalservice.ProfessionalServiceCreationPropertiesArgs{
 * 				BillingPeriod: pulumi.String("P1Y"),
 * 				OfferId:       pulumi.String("testprofservice"),
 * 				PublisherId:   pulumi.String("microsoft-contoso"),
 * 				QuoteId:       pulumi.String("quoteabc"),
 * 				SkuId:         pulumi.String("ff051f4f-a6d9-4cbc-8d9a-2a41bd468abc"),
 * 				TermUnit:      pulumi.String("P3Y"),
 * 			},
 * 			ResourceGroupName: pulumi.String("my-ps-rg"),
 * 			ResourceName:      pulumi.String("MyContosoPS"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.professionalservice.ProfessionalServiceSubscriptionLevel;
 * import com.pulumi.azurenative.professionalservice.ProfessionalServiceSubscriptionLevelArgs;
 * import com.pulumi.azurenative.professionalservice.inputs.ProfessionalServiceCreationPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var professionalServiceSubscriptionLevel = new ProfessionalServiceSubscriptionLevel("professionalServiceSubscriptionLevel", ProfessionalServiceSubscriptionLevelArgs.builder()
 *             .location("global")
 *             .name("MyContosoPS")
 *             .properties(ProfessionalServiceCreationPropertiesArgs.builder()
 *                 .billingPeriod("P1Y")
 *                 .offerId("testprofservice")
 *                 .publisherId("microsoft-contoso")
 *                 .quoteId("quoteabc")
 *                 .skuId("ff051f4f-a6d9-4cbc-8d9a-2a41bd468abc")
 *                 .termUnit("P3Y")
 *                 .build())
 *             .resourceGroupName("my-ps-rg")
 *             .resourceName("MyContosoPS")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:professionalservice:ProfessionalServiceSubscriptionLevel MyContosoPS /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ProfessionalService/resources/{resourceName}
 * ```
 * @property location Resource location. Only value allowed for ProfessionalService is 'global'
 * @property name The resource name
 * @property properties Properties of the ProfessionalService resource that are relevant for creation.
 * @property resourceGroupName The name of the resource group.
 * @property resourceName The name of the resource.
 * @property subscriptionId The Azure subscription ID. This is a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000)
 * @property tags the resource tags.
 */
public data class ProfessionalServiceSubscriptionLevelArgs(
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val properties: Output<ProfessionalServiceCreationPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val subscriptionId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.professionalservice.ProfessionalServiceSubscriptionLevelArgs> {
    override fun toJava(): com.pulumi.azurenative.professionalservice.ProfessionalServiceSubscriptionLevelArgs =
        com.pulumi.azurenative.professionalservice.ProfessionalServiceSubscriptionLevelArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ProfessionalServiceSubscriptionLevelArgs].
 */
@PulumiTagMarker
public class ProfessionalServiceSubscriptionLevelArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var properties: Output<ProfessionalServiceCreationPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var subscriptionId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Resource location. Only value allowed for ProfessionalService is 'global'
     */
    @JvmName("tvrvxerqoxhxcitx")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The resource name
     */
    @JvmName("jjqeqkcimudbxbbf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Properties of the ProfessionalService resource that are relevant for creation.
     */
    @JvmName("rpmbrqbpcshphila")
    public suspend fun properties(`value`: Output<ProfessionalServiceCreationPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("vgrkfdytrfiecbxg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("omjamejdemfginvo")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value The Azure subscription ID. This is a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000)
     */
    @JvmName("oeuaijwlfgasekfc")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value the resource tags.
     */
    @JvmName("donbykjtorljdocw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Resource location. Only value allowed for ProfessionalService is 'global'
     */
    @JvmName("tcknoppwdvxcbshe")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The resource name
     */
    @JvmName("nkmbrfsyvyngipih")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Properties of the ProfessionalService resource that are relevant for creation.
     */
    @JvmName("xpvqcglhjnqdsgjb")
    public suspend fun properties(`value`: ProfessionalServiceCreationPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of the ProfessionalService resource that are relevant for creation.
     */
    @JvmName("aqleivvdaynjlcrf")
    public suspend fun properties(argument: suspend ProfessionalServiceCreationPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ProfessionalServiceCreationPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("xkgeghehvrpdsiuv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("jvrqarsdsnbitiiu")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value The Azure subscription ID. This is a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000)
     */
    @JvmName("exooqoicwodrnccp")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    /**
     * @param value the resource tags.
     */
    @JvmName("heqewjhxqpkqueih")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values the resource tags.
     */
    @JvmName("xmdqxxiwhhnvwgwn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ProfessionalServiceSubscriptionLevelArgs =
        ProfessionalServiceSubscriptionLevelArgs(
            location = location,
            name = name,
            properties = properties,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
            subscriptionId = subscriptionId,
            tags = tags,
        )
}
