@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin

import com.pulumi.azurenative.providerhub.DefaultRolloutArgs.builder
import com.pulumi.azurenative.providerhub.kotlin.inputs.DefaultRolloutPropertiesArgs
import com.pulumi.azurenative.providerhub.kotlin.inputs.DefaultRolloutPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Default rollout definition.
 * Azure REST API version: 2021-09-01-preview. Prior API version in Azure Native 1.x: 2020-11-20.
 * ## Example Usage
 * ### DefaultRollouts_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var defaultRollout = new AzureNative.ProviderHub.DefaultRollout("defaultRollout", new()
 *     {
 *         Properties = new AzureNative.ProviderHub.Inputs.DefaultRolloutPropertiesArgs
 *         {
 *             Specification = new AzureNative.ProviderHub.Inputs.DefaultRolloutPropertiesSpecificationArgs
 *             {
 *                 Canary = new AzureNative.ProviderHub.Inputs.DefaultRolloutSpecificationCanaryArgs
 *                 {
 *                     SkipRegions = new[]
 *                     {
 *                         "eastus2euap",
 *                     },
 *                 },
 *                 ExpeditedRollout = new AzureNative.ProviderHub.Inputs.DefaultRolloutSpecificationExpeditedRolloutArgs
 *                 {
 *                     Enabled = true,
 *                 },
 *                 RestOfTheWorldGroupTwo = new AzureNative.ProviderHub.Inputs.DefaultRolloutSpecificationRestOfTheWorldGroupTwoArgs
 *                 {
 *                     WaitDuration = "PT4H",
 *                 },
 *             },
 *         },
 *         ProviderNamespace = "Microsoft.Contoso",
 *         RolloutName = "2020week10",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/providerhub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := providerhub.NewDefaultRollout(ctx, "defaultRollout", &providerhub.DefaultRolloutArgs{
 * 			Properties: &providerhub.DefaultRolloutPropertiesArgs{
 * 				Specification: &providerhub.DefaultRolloutPropertiesSpecificationArgs{
 * 					Canary: &providerhub.DefaultRolloutSpecificationCanaryArgs{
 * 						SkipRegions: pulumi.StringArray{
 * 							pulumi.String("eastus2euap"),
 * 						},
 * 					},
 * 					ExpeditedRollout: &providerhub.DefaultRolloutSpecificationExpeditedRolloutArgs{
 * 						Enabled: pulumi.Bool(true),
 * 					},
 * 					RestOfTheWorldGroupTwo: &providerhub.DefaultRolloutSpecificationRestOfTheWorldGroupTwoArgs{
 * 						WaitDuration: pulumi.String("PT4H"),
 * 					},
 * 				},
 * 			},
 * 			ProviderNamespace: pulumi.String("Microsoft.Contoso"),
 * 			RolloutName:       pulumi.String("2020week10"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.providerhub.DefaultRollout;
 * import com.pulumi.azurenative.providerhub.DefaultRolloutArgs;
 * import com.pulumi.azurenative.providerhub.inputs.DefaultRolloutPropertiesArgs;
 * import com.pulumi.azurenative.providerhub.inputs.DefaultRolloutPropertiesSpecificationArgs;
 * import com.pulumi.azurenative.providerhub.inputs.DefaultRolloutSpecificationCanaryArgs;
 * import com.pulumi.azurenative.providerhub.inputs.DefaultRolloutSpecificationExpeditedRolloutArgs;
 * import com.pulumi.azurenative.providerhub.inputs.DefaultRolloutSpecificationRestOfTheWorldGroupTwoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultRollout = new DefaultRollout("defaultRollout", DefaultRolloutArgs.builder()
 *             .properties(DefaultRolloutPropertiesArgs.builder()
 *                 .specification(DefaultRolloutPropertiesSpecificationArgs.builder()
 *                     .canary(DefaultRolloutSpecificationCanaryArgs.builder()
 *                         .skipRegions("eastus2euap")
 *                         .build())
 *                     .expeditedRollout(DefaultRolloutSpecificationExpeditedRolloutArgs.builder()
 *                         .enabled(true)
 *                         .build())
 *                     .restOfTheWorldGroupTwo(DefaultRolloutSpecificationRestOfTheWorldGroupTwoArgs.builder()
 *                         .waitDuration("PT4H")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .providerNamespace("Microsoft.Contoso")
 *             .rolloutName("2020week10")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:providerhub:DefaultRollout Microsoft.Contoso/2020week10 /subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/defaultRollouts/{rolloutName}
 * ```
 * @property properties Properties of the rollout.
 * @property providerNamespace The name of the resource provider hosted within ProviderHub.
 * @property rolloutName The rollout name.
 */
public data class DefaultRolloutArgs(
    public val properties: Output<DefaultRolloutPropertiesArgs>? = null,
    public val providerNamespace: Output<String>? = null,
    public val rolloutName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.DefaultRolloutArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.DefaultRolloutArgs =
        com.pulumi.azurenative.providerhub.DefaultRolloutArgs.builder()
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .providerNamespace(providerNamespace?.applyValue({ args0 -> args0 }))
            .rolloutName(rolloutName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefaultRolloutArgs].
 */
@PulumiTagMarker
public class DefaultRolloutArgsBuilder internal constructor() {
    private var properties: Output<DefaultRolloutPropertiesArgs>? = null

    private var providerNamespace: Output<String>? = null

    private var rolloutName: Output<String>? = null

    /**
     * @param value Properties of the rollout.
     */
    @JvmName("ayokhmdoyhdoaoxm")
    public suspend fun properties(`value`: Output<DefaultRolloutPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource provider hosted within ProviderHub.
     */
    @JvmName("cpquanigtucuuomo")
    public suspend fun providerNamespace(`value`: Output<String>) {
        this.providerNamespace = value
    }

    /**
     * @param value The rollout name.
     */
    @JvmName("fxxmwshnbtdkkbvx")
    public suspend fun rolloutName(`value`: Output<String>) {
        this.rolloutName = value
    }

    /**
     * @param value Properties of the rollout.
     */
    @JvmName("fgumxqsykonejwle")
    public suspend fun properties(`value`: DefaultRolloutPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of the rollout.
     */
    @JvmName("wjleismhieogpqes")
    public suspend fun properties(argument: suspend DefaultRolloutPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DefaultRolloutPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource provider hosted within ProviderHub.
     */
    @JvmName("wgxmjnbfjsdxcryr")
    public suspend fun providerNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerNamespace = mapped
    }

    /**
     * @param value The rollout name.
     */
    @JvmName("ewspkberwoxmsvhn")
    public suspend fun rolloutName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rolloutName = mapped
    }

    internal fun build(): DefaultRolloutArgs = DefaultRolloutArgs(
        properties = properties,
        providerNamespace = providerNamespace,
        rolloutName = rolloutName,
    )
}
