@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin

import com.pulumi.azurenative.providerhub.NotificationRegistrationArgs.builder
import com.pulumi.azurenative.providerhub.kotlin.inputs.NotificationRegistrationPropertiesArgs
import com.pulumi.azurenative.providerhub.kotlin.inputs.NotificationRegistrationPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *  /* /* /*
 * The notification registration definition.
 * Azure REST API version: 2021-09-01-preview. Prior API version in Azure Native 1.x: 2020-11-20.
 * ## Example Usage
 * ### NotificationRegistrations_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var notificationRegistration = new AzureNative.ProviderHub.NotificationRegistration("notificationRegistration", new()
 *     {
 *         NotificationRegistrationName = "fooNotificationRegistration",
 *         Properties = new AzureNative.ProviderHub.Inputs.NotificationRegistrationPropertiesArgs
 *         {
 *             IncludedEvents = new[]
 *             {
 *                 "*/write",
 *                 "Microsoft.Contoso/employees/delete",
 *             },
 *             MessageScope = AzureNative.ProviderHub.MessageScope.RegisteredSubscriptions,
 *             NotificationEndpoints = new[]
 *             {
 *                 new AzureNative.ProviderHub.Inputs.NotificationEndpointArgs
 *                 {
 *                     Locations = new[]
 *                     {
 *                         "",
 *                         "East US",
 *                     },
 *                     NotificationDestination = "/subscriptions/ac6bcfb5-3dc1-491f-95a6-646b89bf3e88/resourceGroups/mgmtexp-eastus/providers/Microsoft.EventHub/namespaces/unitedstates-mgmtexpint/eventhubs/armlinkednotifications",
 *                 },
 *                 new AzureNative.ProviderHub.Inputs.NotificationEndpointArgs
 *                 {
 *                     Locations = new[]
 *                     {
 *                         "North Europe",
 *                     },
 *                     NotificationDestination = "/subscriptions/ac6bcfb5-3dc1-491f-95a6-646b89bf3e88/resourceGroups/mgmtexp-northeurope/providers/Microsoft.EventHub/namespaces/europe-mgmtexpint/eventhubs/armlinkednotifications",
 *                 },
 *             },
 *             NotificationMode = AzureNative.ProviderHub.NotificationMode.EventHub,
 *         },
 *         ProviderNamespace = "Microsoft.Contoso",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/providerhub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := providerhub.NewNotificationRegistration(ctx, "notificationRegistration", &providerhub.NotificationRegistrationArgs{
 * 			NotificationRegistrationName: pulumi.String("fooNotificationRegistration"),
 * 			Properties: &providerhub.NotificationRegistrationPropertiesArgs{
 * 				IncludedEvents: pulumi.StringArray{
 * 					pulumi.String("*/write"),
 * 					pulumi.String("Microsoft.Contoso/employees/delete"),
 * 				},
 * 				MessageScope: pulumi.String(providerhub.MessageScopeRegisteredSubscriptions),
 * 				NotificationEndpoints: providerhub.NotificationEndpointArray{
 * 					&providerhub.NotificationEndpointArgs{
 * 						Locations: pulumi.StringArray{
 * 							pulumi.String(""),
 * 							pulumi.String("East US"),
 * 						},
 * 						NotificationDestination: pulumi.String("/subscriptions/ac6bcfb5-3dc1-491f-95a6-646b89bf3e88/resourceGroups/mgmtexp-eastus/providers/Microsoft.EventHub/namespaces/unitedstates-mgmtexpint/eventhubs/armlinkednotifications"),
 * 					},
 * 					&providerhub.NotificationEndpointArgs{
 * 						Locations: pulumi.StringArray{
 * 							pulumi.String("North Europe"),
 * 						},
 * 						NotificationDestination: pulumi.String("/subscriptions/ac6bcfb5-3dc1-491f-95a6-646b89bf3e88/resourceGroups/mgmtexp-northeurope/providers/Microsoft.EventHub/namespaces/europe-mgmtexpint/eventhubs/armlinkednotifications"),
 * 					},
 * 				},
 * 				NotificationMode: pulumi.String(providerhub.NotificationModeEventHub),
 * 			},
 * 			ProviderNamespace: pulumi.String("Microsoft.Contoso"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.providerhub.NotificationRegistration;
 * import com.pulumi.azurenative.providerhub.NotificationRegistrationArgs;
 * import com.pulumi.azurenative.providerhub.inputs.NotificationRegistrationPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var notificationRegistration = new NotificationRegistration("notificationRegistration", NotificationRegistrationArgs.builder()
 *             .notificationRegistrationName("fooNotificationRegistration")
 *             .properties(NotificationRegistrationPropertiesArgs.builder()
 *                 .includedEvents(
 *                     "*/write",
 *                     "Microsoft.Contoso/employees/delete")
 *                 .messageScope("RegisteredSubscriptions")
 *                 .notificationEndpoints(
 *                     NotificationEndpointArgs.builder()
 *                         .locations(
 *                             "",
 *                             "East US")
 *                         .notificationDestination("/subscriptions/ac6bcfb5-3dc1-491f-95a6-646b89bf3e88/resourceGroups/mgmtexp-eastus/providers/Microsoft.EventHub/namespaces/unitedstates-mgmtexpint/eventhubs/armlinkednotifications")
 *                         .build(),
 *                     NotificationEndpointArgs.builder()
 *                         .locations("North Europe")
 *                         .notificationDestination("/subscriptions/ac6bcfb5-3dc1-491f-95a6-646b89bf3e88/resourceGroups/mgmtexp-northeurope/providers/Microsoft.EventHub/namespaces/europe-mgmtexpint/eventhubs/armlinkednotifications")
 *                         .build())
 *                 .notificationMode("EventHub")
 *                 .build())
 *             .providerNamespace("Microsoft.Contoso")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:providerhub:NotificationRegistration fooNotificationRegistration /subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/notificationRegistrations/{notificationRegistrationName}
 * ```
 * @property notificationRegistrationName The notification registration.
 * @property properties
 * @property providerNamespace The name of the resource provider hosted within ProviderHub.
 */
public data class NotificationRegistrationArgs(
    public val notificationRegistrationName: Output<String>? = null,
    public val properties: Output<NotificationRegistrationPropertiesArgs>? = null,
    public val providerNamespace: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.NotificationRegistrationArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.NotificationRegistrationArgs =
        com.pulumi.azurenative.providerhub.NotificationRegistrationArgs.builder()
            .notificationRegistrationName(notificationRegistrationName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .providerNamespace(providerNamespace?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NotificationRegistrationArgs].
 */
@PulumiTagMarker
public class NotificationRegistrationArgsBuilder internal constructor() {
    private var notificationRegistrationName: Output<String>? = null

    private var properties: Output<NotificationRegistrationPropertiesArgs>? = null

    private var providerNamespace: Output<String>? = null

    /**
     * @param value The notification registration.
     */
    @JvmName("uogqidqbuawaovfk")
    public suspend fun notificationRegistrationName(`value`: Output<String>) {
        this.notificationRegistrationName = value
    }

    /**
     * @param value
     */
    @JvmName("pwftummtthhdocro")
    public suspend fun properties(`value`: Output<NotificationRegistrationPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource provider hosted within ProviderHub.
     */
    @JvmName("qyvtdjinblaonqaj")
    public suspend fun providerNamespace(`value`: Output<String>) {
        this.providerNamespace = value
    }

    /**
     * @param value The notification registration.
     */
    @JvmName("hlnomnvejdbakawi")
    public suspend fun notificationRegistrationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationRegistrationName = mapped
    }

    /**
     * @param value
     */
    @JvmName("dhedjvvxjjvefhje")
    public suspend fun properties(`value`: NotificationRegistrationPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument
     */
    @JvmName("lcrowjopugainqya")
    public suspend fun properties(argument: suspend NotificationRegistrationPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = NotificationRegistrationPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource provider hosted within ProviderHub.
     */
    @JvmName("katnspgpvqiskvtv")
    public suspend fun providerNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerNamespace = mapped
    }

    internal fun build(): NotificationRegistrationArgs = NotificationRegistrationArgs(
        notificationRegistrationName = notificationRegistrationName,
        properties = properties,
        providerNamespace = providerNamespace,
    )
}
