@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [OperationByProviderRegistration].
 */
@PulumiTagMarker
public class OperationByProviderRegistrationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OperationByProviderRegistrationArgs = OperationByProviderRegistrationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OperationByProviderRegistrationArgsBuilder.() -> Unit) {
        val builder = OperationByProviderRegistrationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): OperationByProviderRegistration {
        val builtJavaResource =
            com.pulumi.azurenative.providerhub.OperationByProviderRegistration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return OperationByProviderRegistration(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2021-09-01-preview. Prior API version in Azure Native 1.x: 2020-11-20.
 * Other available API versions: 2021-05-01-preview.
 * ## Example Usage
 * ### Operations_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var operationByProviderRegistration = new AzureNative.ProviderHub.OperationByProviderRegistration("operationByProviderRegistration", new()
 *     {
 *         ProviderNamespace = "Microsoft.Contoso",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/providerhub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := providerhub.NewOperationByProviderRegistration(ctx, "operationByProviderRegistration", &providerhub.OperationByProviderRegistrationArgs{
 * 			ProviderNamespace: pulumi.String("Microsoft.Contoso"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.providerhub.OperationByProviderRegistration;
 * import com.pulumi.azurenative.providerhub.OperationByProviderRegistrationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var operationByProviderRegistration = new OperationByProviderRegistration("operationByProviderRegistration", OperationByProviderRegistrationArgs.builder()
 *             .providerNamespace("Microsoft.Contoso")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:providerhub:OperationByProviderRegistration myresource1 /subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/operations/default
 * ```
 */
public class OperationByProviderRegistration internal constructor(
    override val javaResource: com.pulumi.azurenative.providerhub.OperationByProviderRegistration,
) : KotlinCustomResource(javaResource, OperationByProviderRegistrationMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object OperationByProviderRegistrationMapper :
    ResourceMapper<OperationByProviderRegistration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.providerhub.OperationByProviderRegistration::class == javaResource::class

    override fun map(javaResource: Resource): OperationByProviderRegistration =
        OperationByProviderRegistration(
            javaResource as
                com.pulumi.azurenative.providerhub.OperationByProviderRegistration,
        )
}

/**
 * @see [OperationByProviderRegistration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OperationByProviderRegistration].
 */
public suspend fun operationByProviderRegistration(
    name: String,
    block: suspend OperationByProviderRegistrationResourceBuilder.() -> Unit,
): OperationByProviderRegistration {
    val builder = OperationByProviderRegistrationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OperationByProviderRegistration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun operationByProviderRegistration(name: String): OperationByProviderRegistration {
    val builder = OperationByProviderRegistrationResourceBuilder()
    builder.name(name)
    return builder.build()
}
