@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin

import com.pulumi.azurenative.providerhub.ProviderhubFunctions.getDefaultRolloutPlain
import com.pulumi.azurenative.providerhub.ProviderhubFunctions.getNotificationRegistrationPlain
import com.pulumi.azurenative.providerhub.ProviderhubFunctions.getProviderRegistrationPlain
import com.pulumi.azurenative.providerhub.ProviderhubFunctions.getResourceTypeRegistrationPlain
import com.pulumi.azurenative.providerhub.ProviderhubFunctions.getSkusNestedResourceTypeFirstPlain
import com.pulumi.azurenative.providerhub.ProviderhubFunctions.getSkusNestedResourceTypeSecondPlain
import com.pulumi.azurenative.providerhub.ProviderhubFunctions.getSkusNestedResourceTypeThirdPlain
import com.pulumi.azurenative.providerhub.ProviderhubFunctions.getSkusPlain
import com.pulumi.azurenative.providerhub.kotlin.inputs.GetDefaultRolloutPlainArgs
import com.pulumi.azurenative.providerhub.kotlin.inputs.GetDefaultRolloutPlainArgsBuilder
import com.pulumi.azurenative.providerhub.kotlin.inputs.GetNotificationRegistrationPlainArgs
import com.pulumi.azurenative.providerhub.kotlin.inputs.GetNotificationRegistrationPlainArgsBuilder
import com.pulumi.azurenative.providerhub.kotlin.inputs.GetProviderRegistrationPlainArgs
import com.pulumi.azurenative.providerhub.kotlin.inputs.GetProviderRegistrationPlainArgsBuilder
import com.pulumi.azurenative.providerhub.kotlin.inputs.GetResourceTypeRegistrationPlainArgs
import com.pulumi.azurenative.providerhub.kotlin.inputs.GetResourceTypeRegistrationPlainArgsBuilder
import com.pulumi.azurenative.providerhub.kotlin.inputs.GetSkusNestedResourceTypeFirstPlainArgs
import com.pulumi.azurenative.providerhub.kotlin.inputs.GetSkusNestedResourceTypeFirstPlainArgsBuilder
import com.pulumi.azurenative.providerhub.kotlin.inputs.GetSkusNestedResourceTypeSecondPlainArgs
import com.pulumi.azurenative.providerhub.kotlin.inputs.GetSkusNestedResourceTypeSecondPlainArgsBuilder
import com.pulumi.azurenative.providerhub.kotlin.inputs.GetSkusNestedResourceTypeThirdPlainArgs
import com.pulumi.azurenative.providerhub.kotlin.inputs.GetSkusNestedResourceTypeThirdPlainArgsBuilder
import com.pulumi.azurenative.providerhub.kotlin.inputs.GetSkusPlainArgs
import com.pulumi.azurenative.providerhub.kotlin.inputs.GetSkusPlainArgsBuilder
import com.pulumi.azurenative.providerhub.kotlin.outputs.GetDefaultRolloutResult
import com.pulumi.azurenative.providerhub.kotlin.outputs.GetNotificationRegistrationResult
import com.pulumi.azurenative.providerhub.kotlin.outputs.GetProviderRegistrationResult
import com.pulumi.azurenative.providerhub.kotlin.outputs.GetResourceTypeRegistrationResult
import com.pulumi.azurenative.providerhub.kotlin.outputs.GetSkusNestedResourceTypeFirstResult
import com.pulumi.azurenative.providerhub.kotlin.outputs.GetSkusNestedResourceTypeSecondResult
import com.pulumi.azurenative.providerhub.kotlin.outputs.GetSkusNestedResourceTypeThirdResult
import com.pulumi.azurenative.providerhub.kotlin.outputs.GetSkusResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.providerhub.kotlin.outputs.GetDefaultRolloutResult.Companion.toKotlin as getDefaultRolloutResultToKotlin
import com.pulumi.azurenative.providerhub.kotlin.outputs.GetNotificationRegistrationResult.Companion.toKotlin as getNotificationRegistrationResultToKotlin
import com.pulumi.azurenative.providerhub.kotlin.outputs.GetProviderRegistrationResult.Companion.toKotlin as getProviderRegistrationResultToKotlin
import com.pulumi.azurenative.providerhub.kotlin.outputs.GetResourceTypeRegistrationResult.Companion.toKotlin as getResourceTypeRegistrationResultToKotlin
import com.pulumi.azurenative.providerhub.kotlin.outputs.GetSkusNestedResourceTypeFirstResult.Companion.toKotlin as getSkusNestedResourceTypeFirstResultToKotlin
import com.pulumi.azurenative.providerhub.kotlin.outputs.GetSkusNestedResourceTypeSecondResult.Companion.toKotlin as getSkusNestedResourceTypeSecondResultToKotlin
import com.pulumi.azurenative.providerhub.kotlin.outputs.GetSkusNestedResourceTypeThirdResult.Companion.toKotlin as getSkusNestedResourceTypeThirdResultToKotlin
import com.pulumi.azurenative.providerhub.kotlin.outputs.GetSkusResult.Companion.toKotlin as getSkusResultToKotlin

public object ProviderhubFunctions {
    /**
     * Gets the default rollout details.
     * Azure REST API version: 2021-09-01-preview.
     * @param argument null
     * @return Default rollout definition.
     */
    public suspend fun getDefaultRollout(argument: GetDefaultRolloutPlainArgs): GetDefaultRolloutResult =
        getDefaultRolloutResultToKotlin(getDefaultRolloutPlain(argument.toJava()).await())

    /**
     * @see [getDefaultRollout].
     * @param providerNamespace The name of the resource provider hosted within ProviderHub.
     * @param rolloutName The rollout name.
     * @return Default rollout definition.
     */
    public suspend fun getDefaultRollout(providerNamespace: String, rolloutName: String): GetDefaultRolloutResult {
        val argument = GetDefaultRolloutPlainArgs(
            providerNamespace = providerNamespace,
            rolloutName = rolloutName,
        )
        return getDefaultRolloutResultToKotlin(getDefaultRolloutPlain(argument.toJava()).await())
    }

    /**
     * @see [getDefaultRollout].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;providerhub&#46;kotlin&#46;inputs&#46;GetDefaultRolloutPlainArgs].
     * @return Default rollout definition.
     */
    public suspend fun getDefaultRollout(argument: suspend GetDefaultRolloutPlainArgsBuilder.() -> Unit): GetDefaultRolloutResult {
        val builder = GetDefaultRolloutPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDefaultRolloutResultToKotlin(getDefaultRolloutPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the notification registration details.
     * Azure REST API version: 2021-09-01-preview.
     * @param argument null
     * @return The notification registration definition.
     */
    public suspend fun getNotificationRegistration(argument: GetNotificationRegistrationPlainArgs): GetNotificationRegistrationResult =
        getNotificationRegistrationResultToKotlin(getNotificationRegistrationPlain(argument.toJava()).await())

    /**
     * @see [getNotificationRegistration].
     * @param notificationRegistrationName The notification registration.
     * @param providerNamespace The name of the resource provider hosted within ProviderHub.
     * @return The notification registration definition.
     */
    public suspend fun getNotificationRegistration(
        notificationRegistrationName: String,
        providerNamespace: String,
    ): GetNotificationRegistrationResult {
        val argument = GetNotificationRegistrationPlainArgs(
            notificationRegistrationName = notificationRegistrationName,
            providerNamespace = providerNamespace,
        )
        return getNotificationRegistrationResultToKotlin(getNotificationRegistrationPlain(argument.toJava()).await())
    }

    /**
     * @see [getNotificationRegistration].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;providerhub&#46;kotlin&#46;inputs&#46;GetNotificationRegistrationPlainArgs].
     * @return The notification registration definition.
     */
    public suspend fun getNotificationRegistration(argument: suspend GetNotificationRegistrationPlainArgsBuilder.() -> Unit): GetNotificationRegistrationResult {
        val builder = GetNotificationRegistrationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNotificationRegistrationResultToKotlin(getNotificationRegistrationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the provider registration details.
     * Azure REST API version: 2021-09-01-preview.
     * @param argument null
     * @return null
     */
    public suspend fun getProviderRegistration(argument: GetProviderRegistrationPlainArgs): GetProviderRegistrationResult =
        getProviderRegistrationResultToKotlin(getProviderRegistrationPlain(argument.toJava()).await())

    /**
     * @see [getProviderRegistration].
     * @param providerNamespace The name of the resource provider hosted within ProviderHub.
     * @return null
     */
    public suspend fun getProviderRegistration(providerNamespace: String): GetProviderRegistrationResult {
        val argument = GetProviderRegistrationPlainArgs(
            providerNamespace = providerNamespace,
        )
        return getProviderRegistrationResultToKotlin(getProviderRegistrationPlain(argument.toJava()).await())
    }

    /**
     * @see [getProviderRegistration].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;providerhub&#46;kotlin&#46;inputs&#46;GetProviderRegistrationPlainArgs].
     * @return null
     */
    public suspend fun getProviderRegistration(argument: suspend GetProviderRegistrationPlainArgsBuilder.() -> Unit): GetProviderRegistrationResult {
        val builder = GetProviderRegistrationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProviderRegistrationResultToKotlin(getProviderRegistrationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a resource type details in the given subscription and provider.
     * Azure REST API version: 2021-09-01-preview.
     * @param argument null
     * @return null
     */
    public suspend fun getResourceTypeRegistration(argument: GetResourceTypeRegistrationPlainArgs): GetResourceTypeRegistrationResult =
        getResourceTypeRegistrationResultToKotlin(getResourceTypeRegistrationPlain(argument.toJava()).await())

    /**
     * @see [getResourceTypeRegistration].
     * @param providerNamespace The name of the resource provider hosted within ProviderHub.
     * @param resourceType The resource type.
     * @return null
     */
    public suspend fun getResourceTypeRegistration(providerNamespace: String, resourceType: String): GetResourceTypeRegistrationResult {
        val argument = GetResourceTypeRegistrationPlainArgs(
            providerNamespace = providerNamespace,
            resourceType = resourceType,
        )
        return getResourceTypeRegistrationResultToKotlin(getResourceTypeRegistrationPlain(argument.toJava()).await())
    }

    /**
     * @see [getResourceTypeRegistration].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;providerhub&#46;kotlin&#46;inputs&#46;GetResourceTypeRegistrationPlainArgs].
     * @return null
     */
    public suspend fun getResourceTypeRegistration(argument: suspend GetResourceTypeRegistrationPlainArgsBuilder.() -> Unit): GetResourceTypeRegistrationResult {
        val builder = GetResourceTypeRegistrationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getResourceTypeRegistrationResultToKotlin(getResourceTypeRegistrationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the sku details for the given resource type and sku name.
     * Azure REST API version: 2021-09-01-preview.
     * @param argument null
     * @return null
     */
    public suspend fun getSkus(argument: GetSkusPlainArgs): GetSkusResult =
        getSkusResultToKotlin(getSkusPlain(argument.toJava()).await())

    /**
     * @see [getSkus].
     * @param providerNamespace The name of the resource provider hosted within ProviderHub.
     * @param resourceType The resource type.
     * @param sku The SKU.
     * @return null
     */
    public suspend fun getSkus(
        providerNamespace: String,
        resourceType: String,
        sku: String,
    ): GetSkusResult {
        val argument = GetSkusPlainArgs(
            providerNamespace = providerNamespace,
            resourceType = resourceType,
            sku = sku,
        )
        return getSkusResultToKotlin(getSkusPlain(argument.toJava()).await())
    }

    /**
     * @see [getSkus].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;providerhub&#46;kotlin&#46;inputs&#46;GetSkusPlainArgs].
     * @return null
     */
    public suspend fun getSkus(argument: suspend GetSkusPlainArgsBuilder.() -> Unit): GetSkusResult {
        val builder = GetSkusPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSkusResultToKotlin(getSkusPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the sku details for the given resource type and sku name.
     * Azure REST API version: 2021-09-01-preview.
     * @param argument null
     * @return null
     */
    public suspend fun getSkusNestedResourceTypeFirst(argument: GetSkusNestedResourceTypeFirstPlainArgs): GetSkusNestedResourceTypeFirstResult =
        getSkusNestedResourceTypeFirstResultToKotlin(getSkusNestedResourceTypeFirstPlain(argument.toJava()).await())

    /**
     * @see [getSkusNestedResourceTypeFirst].
     * @param nestedResourceTypeFirst The first child resource type.
     * @param providerNamespace The name of the resource provider hosted within ProviderHub.
     * @param resourceType The resource type.
     * @param sku The SKU.
     * @return null
     */
    public suspend fun getSkusNestedResourceTypeFirst(
        nestedResourceTypeFirst: String,
        providerNamespace: String,
        resourceType: String,
        sku: String,
    ): GetSkusNestedResourceTypeFirstResult {
        val argument = GetSkusNestedResourceTypeFirstPlainArgs(
            nestedResourceTypeFirst = nestedResourceTypeFirst,
            providerNamespace = providerNamespace,
            resourceType = resourceType,
            sku = sku,
        )
        return getSkusNestedResourceTypeFirstResultToKotlin(getSkusNestedResourceTypeFirstPlain(argument.toJava()).await())
    }

    /**
     * @see [getSkusNestedResourceTypeFirst].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;providerhub&#46;kotlin&#46;inputs&#46;GetSkusNestedResourceTypeFirstPlainArgs].
     * @return null
     */
    public suspend fun getSkusNestedResourceTypeFirst(argument: suspend GetSkusNestedResourceTypeFirstPlainArgsBuilder.() -> Unit): GetSkusNestedResourceTypeFirstResult {
        val builder = GetSkusNestedResourceTypeFirstPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSkusNestedResourceTypeFirstResultToKotlin(getSkusNestedResourceTypeFirstPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the sku details for the given resource type and sku name.
     * Azure REST API version: 2021-09-01-preview.
     * @param argument null
     * @return null
     */
    public suspend fun getSkusNestedResourceTypeSecond(argument: GetSkusNestedResourceTypeSecondPlainArgs): GetSkusNestedResourceTypeSecondResult =
        getSkusNestedResourceTypeSecondResultToKotlin(getSkusNestedResourceTypeSecondPlain(argument.toJava()).await())

    /**
     * @see [getSkusNestedResourceTypeSecond].
     * @param nestedResourceTypeFirst The first child resource type.
     * @param nestedResourceTypeSecond The second child resource type.
     * @param providerNamespace The name of the resource provider hosted within ProviderHub.
     * @param resourceType The resource type.
     * @param sku The SKU.
     * @return null
     */
    public suspend fun getSkusNestedResourceTypeSecond(
        nestedResourceTypeFirst: String,
        nestedResourceTypeSecond: String,
        providerNamespace: String,
        resourceType: String,
        sku: String,
    ): GetSkusNestedResourceTypeSecondResult {
        val argument = GetSkusNestedResourceTypeSecondPlainArgs(
            nestedResourceTypeFirst = nestedResourceTypeFirst,
            nestedResourceTypeSecond = nestedResourceTypeSecond,
            providerNamespace = providerNamespace,
            resourceType = resourceType,
            sku = sku,
        )
        return getSkusNestedResourceTypeSecondResultToKotlin(getSkusNestedResourceTypeSecondPlain(argument.toJava()).await())
    }

    /**
     * @see [getSkusNestedResourceTypeSecond].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;providerhub&#46;kotlin&#46;inputs&#46;GetSkusNestedResourceTypeSecondPlainArgs].
     * @return null
     */
    public suspend fun getSkusNestedResourceTypeSecond(argument: suspend GetSkusNestedResourceTypeSecondPlainArgsBuilder.() -> Unit): GetSkusNestedResourceTypeSecondResult {
        val builder = GetSkusNestedResourceTypeSecondPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSkusNestedResourceTypeSecondResultToKotlin(getSkusNestedResourceTypeSecondPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the sku details for the given resource type and sku name.
     * Azure REST API version: 2021-09-01-preview.
     * @param argument null
     * @return null
     */
    public suspend fun getSkusNestedResourceTypeThird(argument: GetSkusNestedResourceTypeThirdPlainArgs): GetSkusNestedResourceTypeThirdResult =
        getSkusNestedResourceTypeThirdResultToKotlin(getSkusNestedResourceTypeThirdPlain(argument.toJava()).await())

    /**
     * @see [getSkusNestedResourceTypeThird].
     * @param nestedResourceTypeFirst The first child resource type.
     * @param nestedResourceTypeSecond The second child resource type.
     * @param nestedResourceTypeThird The third child resource type.
     * @param providerNamespace The name of the resource provider hosted within ProviderHub.
     * @param resourceType The resource type.
     * @param sku The SKU.
     * @return null
     */
    public suspend fun getSkusNestedResourceTypeThird(
        nestedResourceTypeFirst: String,
        nestedResourceTypeSecond: String,
        nestedResourceTypeThird: String,
        providerNamespace: String,
        resourceType: String,
        sku: String,
    ): GetSkusNestedResourceTypeThirdResult {
        val argument = GetSkusNestedResourceTypeThirdPlainArgs(
            nestedResourceTypeFirst = nestedResourceTypeFirst,
            nestedResourceTypeSecond = nestedResourceTypeSecond,
            nestedResourceTypeThird = nestedResourceTypeThird,
            providerNamespace = providerNamespace,
            resourceType = resourceType,
            sku = sku,
        )
        return getSkusNestedResourceTypeThirdResultToKotlin(getSkusNestedResourceTypeThirdPlain(argument.toJava()).await())
    }

    /**
     * @see [getSkusNestedResourceTypeThird].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;providerhub&#46;kotlin&#46;inputs&#46;GetSkusNestedResourceTypeThirdPlainArgs].
     * @return null
     */
    public suspend fun getSkusNestedResourceTypeThird(argument: suspend GetSkusNestedResourceTypeThirdPlainArgsBuilder.() -> Unit): GetSkusNestedResourceTypeThirdResult {
        val builder = GetSkusNestedResourceTypeThirdPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSkusNestedResourceTypeThirdResultToKotlin(getSkusNestedResourceTypeThirdPlain(builtArgument.toJava()).await())
    }
}
